/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.perforce;

import com.pmease.quickbuild.annotation.Choices;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.scm.perforce.Mapping;
import com.pmease.quickbuild.plugin.scm.perforce.PerforceRepository;
import com.pmease.quickbuild.plugin.scm.perforce.StaticSpec;
import com.pmease.quickbuild.plugin.scm.perforce.StaticSpecProvider;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(order=100, name="Input client specification")
@ScriptApi(value="Provide client spec by input directly.")
public class SpecifiedStaticSpecProvider
implements StaticSpecProvider,
Validatable {
    private PerforceRepository repository;
    private String view;
    private List<String> options = new ArrayList<String>();
    private String submitOptions = "submitunchanged";
    private String lineEnd = "local";
    private String serverId;

    public SpecifiedStaticSpecProvider(PerforceRepository repository) {
        this.repository = repository;
    }

    @Editable(order=100, name="View", description="Specify view of the client, any client name can be used in the mapping and it will be replaced with the actual client name determined by QuickBuild at build time.")
    @NotEmpty
    @Multiline(value=6)
    @ScriptApi(value="Get view of the client.")
    @Scriptable
    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    @Editable(order=150)
    @Choices(value={"submitunchanged", "submitunchanged+reopen", "revertunchanged", "revertunchanged+reopen", "leaveunchanged", "leaveunchanged+reopen"})
    @NotNull
    @ScriptApi(value="Get submit options")
    public String getSubmitOptions() {
        return this.submitOptions;
    }

    public void setSubmitOptions(String submitOptions) {
        this.submitOptions = submitOptions;
    }

    @Editable(order=200)
    @Choices(value={"compress", "modtime", "rmdir", "clobber", "allwrite"})
    @ScriptApi(value="Get client options.")
    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    @Editable(order=300)
    @Choices(value={"local", "unix", "mac", "win", "share"})
    @NotNull
    @ScriptApi(value="Get line end mode.")
    @Scriptable
    public String getLineEnd() {
        return this.lineEnd;
    }

    public void setLineEnd(String lineEnd) {
        this.lineEnd = lineEnd;
    }

    @Editable(order=400, name="Server ID")
    @ScriptApi(value="Get ServerID property.")
    @Scriptable
    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    @Override
    @ScriptApi(value="Get client spec.")
    public StaticSpec getStaticSpec() {
        StaticSpec spec = new StaticSpec();
        spec.setLineEnd(this.getLineEnd());
        spec.setServerId(this.getServerId());
        spec.setOptions(StringUtils.join(this.getOptions().iterator(), (String)" "));
        spec.setSubmitOptions(this.getSubmitOptions());
        spec.setMappings(Mapping.parseView(this.repository, this.getView()));
        return spec;
    }

    @ScriptApi(value="Get repository object.")
    public PerforceRepository getRepository() {
        return this.repository;
    }

    public void validate(Set<String> properties, ErrorContext errorContext) {
        if (properties.contains("view")) {
            try {
                Mapping.parseView(this.repository, this.view);
            }
            catch (Exception e) {
                errorContext.setError("view", e.getMessage());
            }
        }
    }
}

