/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.perforce;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.scm.perforce.PerforceRepository;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.page.error.ErrorMessagePage;
import com.pmease.quickbuild.web.page.source.SourceDiffPage;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class ShelvedChangesPanel
extends Panel {
    public ShelvedChangesPanel(String panelId) {
        super(panelId);
        final boolean viewSourceAllowed = SecurityHelper.hasPermission((String)ConfigurationPermission.VIEW_SOURCE.name());
        this.add(new Component[]{new ListView("repositories", (IModel)new LoadableDetachableModel(){

            protected Object load() {
                File shelvedChangesDir = new File(Context.getBuild().getPublishDir(), PerforceRepository.SHELVED_CHANGES_DIR);
                if (shelvedChangesDir.exists()) {
                    File[] dirs = shelvedChangesDir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File dir) {
                            return Context.getBuild().getRepository(dir.getName()) != null;
                        }
                    });
                    return Arrays.asList(dirs);
                }
                return new ArrayList();
            }
        }){

            protected void populateItem(ListItem item) {
                final File shelvedChangesDirOfRepo = (File)item.getModelObject();
                final Repository repository = Context.getBuild().getRepository(shelvedChangesDirOfRepo.getName());
                item.add(new Component[]{new Label("repositoryName", repository.getName())});
                item.add(new Component[]{new ListView("changes", (IModel)new LoadableDetachableModel(){

                    protected Object load() {
                        return Arrays.asList(shelvedChangesDirOfRepo.listFiles());
                    }
                }){

                    protected void populateItem(ListItem item) {
                        final File changeDir = (File)item.getModelObject();
                        Changeset change = (Changeset)FileUtils.readFileAsObject((File)new File(changeDir, "changeset"));
                        item.add(new Component[]{new Label("user", change.getUser())});
                        item.add(new Component[]{new Label("date", DateUtils.formatDateTime((Date)change.getDate()))});
                        item.add(new Component[]{new Label("comment", StringUtils.formatAsHtml((String)change.getComment())).setEscapeModelStrings(false)});
                        item.add(new Component[]{new ListView("modifications", change.getModifications()){

                            protected void populateItem(ListItem item) {
                                final Modification modification = (Modification)item.getModelObject();
                                item.add(new Component[]{new Label("action", modification.getAction().name())});
                                Link link = new Link("link"){

                                    public void onClick() {
                                        if (!viewSourceAllowed) {
                                            throw new AccessDeniedException();
                                        }
                                        File storedFile = new File(changeDir, PerforceRepository.normalizeRepositoryPath(modification.getPath()));
                                        if (modification.getAction() == Modification.Action.ADD) {
                                            this.setResponsePage((Page)new SourceViewPage(modification.getPath(), FilenameUtils.getExtension((String)modification.getPath()), FileUtils.readFileAsLines((File)storedFile).toArray(new String[0])));
                                        } else {
                                            List originalFileContent = repository.getSourceViewSupport().readSourceByRevision(modification.getPath(), repository.getRevision());
                                            if (originalFileContent == null) {
                                                this.setResponsePage((Page)new ErrorMessagePage("Failed to View Source", "Object '" + modification.getPath() + "@" + repository.getRevision() + "' is not a text file"));
                                            } else {
                                                String[] modifiedSourceLines = FileUtils.readFileAsLines((File)storedFile).toArray(new String[0]);
                                                String[] originalSourceLines = originalFileContent.toArray(new String[0]);
                                                this.setResponsePage((Page)new SourceDiffPage(modification.getPath(), FilenameUtils.getExtension((String)modification.getPath()), modifiedSourceLines, originalSourceLines));
                                            }
                                        }
                                    }

                                    protected void onConfigure() {
                                        super.onConfigure();
                                        this.setEnabled(viewSourceAllowed && modification.getPathType() == Modification.PathType.TEXT && modification.getAction() != Modification.Action.DELETE);
                                    }
                                };
                                link.setPopupSettings(new PopupSettings("popup", 12));
                                link.add(new Component[]{new Label("label", modification.getPath())});
                                item.add(new Component[]{link});
                            }
                        }});
                    }
                }});
            }
        }});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderCSSReference((ResourceReference)new CssResourceReference(ShelvedChangesPanel.class, "shelved-changes.css"));
    }
}

