/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.perforce;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.BuildTabContribution;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.scm.perforce.PerforceRepository;
import com.pmease.quickbuild.plugin.scm.perforce.ShelvedChangesPanel;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.wicket.markup.html.panel.Panel;

public class ShelvedChangesBuildTabContribution
implements BuildTabContribution {
    private static final long serialVersionUID = 1L;

    public int getOrder() {
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tab> getTabs() {
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        final Build build = Context.getBuild();
        if (SecurityHelper.hasPermission((String)ConfigurationPermission.ACCESS_BUILD_CHANGES.name())) {
            File shelvedChangesDir = new File(build.getPublishDir(), PerforceRepository.SHELVED_CHANGES_DIR);
            int count = 0;
            Lock lock = LockUtils.lockForRead((File)shelvedChangesDir);
            try {
                if (shelvedChangesDir.exists()) {
                    File[] dirs;
                    for (File dir : dirs = shelvedChangesDir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File dir) {
                            return build.getRepository(dir.getName()) != null;
                        }
                    })) {
                        count += dir.listFiles().length;
                    }
                }
            }
            finally {
                lock.unlock();
            }
            if (count != 0) {
                tabs.add(new Tab("Shelved Changes", "Shelved Changes (" + count + ")"){
                    private static final long serialVersionUID = 1L;

                    public Panel getPanel(String id, Map<String, String> params) {
                        return new ShelvedChangesPanel(id);
                    }
                });
            }
        }
        return tabs;
    }
}

