/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.perforce;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.scm.perforce.shelvecondition.AlwaysShelve;
import com.pmease.quickbuild.plugin.scm.perforce.shelvecondition.ShelveCondition;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class ShelveSupport
implements Serializable {
    private ShelveCondition shelveCondition = new AlwaysShelve();
    private String shelvedChanges;
    @XStreamOmitField
    private List<String> actualShelvedChanges;
    private String userName;
    private String password;
    private String submitCondition = "build.successful";
    private RevertOption revertOption = RevertOption.REVERT_BEFORE_NEXT_BUILD;

    @Editable(name="Merge Condition", order=10, description="This condition determines whether or not to merge with shelved changes for this repository.")
    @NotNull
    public ShelveCondition getShelveCondition() {
        return this.shelveCondition;
    }

    public void setShelveCondition(ShelveCondition shelveCondition) {
        this.shelveCondition = shelveCondition;
    }

    @Editable(order=100, description="Specify perforce user whose shelved changes should be merged.")
    @NotEmpty
    @Scriptable
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=200, description="Specify password of above perforce user.")
    @NotEmpty
    @Password
    @Scriptable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(order=300, description="Optionally specify change list numbers of shelved changes to merge with. Multple change list numbers should be separated with comma. If not specified, all shelved changes of above user will be merged.")
    @Scriptable
    public String getShelvedChanges() {
        return this.shelvedChanges;
    }

    public void setShelvedChanges(String shelvedChanges) {
        this.shelvedChanges = shelvedChanges;
    }

    @Editable(order=400, description="Shelved changes will be submitted by QuickBuild if this condition evaluates to true.<br><b>NOTE: </b> Make sure the build client is a stream based client when submitting shelved changes to a stream depot; otherwise Perforce will complain with message &quot;Cannot submit from non-stream client&quot;.")
    @Expressions(value={"submit if build is successful", "build.successful", "always submit", "true", "do not submit", "false"})
    @Script
    public String getSubmitCondition() {
        return this.submitCondition;
    }

    public void setSubmitCondition(String submitCondition) {
        this.submitCondition = submitCondition;
    }

    @Editable(order=500, description="Specifies when to revert shelved changes in the build workspace.")
    @NotNull
    public RevertOption getRevertOption() {
        return this.revertOption;
    }

    public void setRevertOption(RevertOption revertOption) {
        this.revertOption = revertOption;
    }

    public List<String> getActualShelvedChanges() {
        return this.actualShelvedChanges;
    }

    public void setActualShelvedChanges(List<String> actualShelvedChanges) {
        this.actualShelvedChanges = actualShelvedChanges;
    }

    public static enum RevertOption {
        REVERT_BEFORE_NEXT_BUILD,
        REVERT_AFTER_CURRENT_BUILD,
        REVERT_AFTER_CURRNT_BUILD_IF_SUCCESSFUL;

    }
}

