/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.perforce;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.execution.SecretMasker;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.ServerService;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.scm.perforce.ClientNameProvider;
import com.pmease.quickbuild.plugin.scm.perforce.Mapping;
import com.pmease.quickbuild.plugin.scm.perforce.NodeAndDirBasedClientName;
import com.pmease.quickbuild.plugin.scm.perforce.P4ProofBuildSupport;
import com.pmease.quickbuild.plugin.scm.perforce.P4SourceViewSupport;
import com.pmease.quickbuild.plugin.scm.perforce.PerforcePlugin;
import com.pmease.quickbuild.plugin.scm.perforce.PerforceRevision;
import com.pmease.quickbuild.plugin.scm.perforce.PerforceSetting;
import com.pmease.quickbuild.plugin.scm.perforce.ShelveSupport;
import com.pmease.quickbuild.plugin.scm.perforce.SpecifiedStaticSpecProvider;
import com.pmease.quickbuild.plugin.scm.perforce.StaticSpec;
import com.pmease.quickbuild.plugin.scm.perforce.StaticSpecProvider;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.RevisionInfo;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.StringUtils;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.oro.text.perl.Perl5Util;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Editable(name="Perforce", description="Configure a Perforce repository here. By default, QuickBuild executes \"p4\" to checkout from the repository, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the Perforce plugin through the plugin management page.")
@ScriptApi
public class PerforceRepository
extends Repository<PerforceRevision> {
    private static final long serialVersionUID = 1L;
    private static final int MAX_CHANGENUMBERS_PER_COMMAND = 25;
    public static String SHELVED_CHANGES_DIR = "p4ShelvedChanges";
    private String port;
    private String buildRevision;
    @XStreamOmitField
    private Map<String, Date> clientSyncTime;
    @XStreamOmitField
    private DateTimeZone serverTimeZone;
    private String userName;
    private String password;
    private ClientNameProvider clientNameProvider = new NodeAndDirBasedClientName(this);
    private StaticSpecProvider staticSpecProvider = new SpecifiedStaticSpecProvider(this);
    private String rootPath;
    private SyncMode syncMode = SyncMode.NORMAL_SYNC;
    private boolean lockLabel = false;
    private String p4charset;
    private boolean reconcile;
    private ShelveSupport shelveSupport;
    private P4ProofBuildSupport proofBuildSupport;
    private String reloadAddress;
    private String additionalSyncOptions;
    private transient DateTimeFormatter dateTimeFormatter;
    private transient StaticSpec staticSpec;
    private transient Map<String, String> tickets;

    @Editable(order=100, name="Perforce Port", description="The Perforce port in the format of &lt;perforce server name&gt;:&lt;port&gt;. For example: <b>perforce-server:1666</b>")
    @NotEmpty
    @ScriptApi(value="Get Perforce port of this repository.")
    @Scriptable
    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Editable(order=150, description="Specify name of the perfoce user used by QuickBuild to interact with Perfoce. This user needs to have client creation permission.")
    @NotEmpty
    @ScriptApi(value="Get the user name to access the repository.")
    @Scriptable
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=200, description="Password for the above user.")
    @Password
    @ScriptApi(value="Get password to access the repository. Null if not specified.")
    @Scriptable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(name="Client Name", order=300, description="Specify name of the client which will be created by QuickBuild to check out code for the build.")
    @NotNull
    @ScriptApi(value="Get client name provider.")
    public ClientNameProvider getClientNameProvider() {
        return this.clientNameProvider;
    }

    public void setClientNameProvider(ClientNameProvider clientNameProvider) {
        this.clientNameProvider = clientNameProvider;
    }

    @ScriptApi(value="Get name of the client to be used for checkout.")
    public String getClientName() {
        return this.getClientNameProvider().getClientName();
    }

    @Editable(order=400, name="Client Specification", description="Choose how the client specification is determined")
    @NotNull
    @ScriptApi(value="Get client spec provider object.")
    public StaticSpecProvider getStaticSpecProvider() {
        return this.staticSpecProvider;
    }

    public void setStaticSpecProvider(StaticSpecProvider staticSpecProvider) {
        this.staticSpecProvider = staticSpecProvider;
    }

    @Editable(order=500, name="Root Directory", description="Optionally specify a path relative to the configuration workspace (NOT the client workspace) which will be used as root directory for the client. If left empty, the configuration workspace itself will be used as root directory")
    @ScriptApi(value="Get path to root directory of the Perforce client. Null if workspace directory itself is used as root directory.")
    @Scriptable
    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    @Editable(order=600, name="Change Number (or Label)", description="Specify change number or label to build against.")
    @Scriptable
    public String getBuildRevision() {
        return this.buildRevision;
    }

    public void setBuildRevision(String buildRevision) {
        this.buildRevision = buildRevision;
    }

    @ScriptApi(value="Get revision of the repository.")
    public PerforceRevision getRevision() {
        return (PerforceRevision)super.getRevision();
    }

    @Editable(name="Sync Mode", order=640, description="The force sync mode adds option &quot;-f&quot; to sync command, while the populate sync mode adds option &quot;-p&quot; to that command. The normal sync mode adds none of these options, and should be used as the default sync mode in most cases.")
    @Advanced
    @NotNull
    public SyncMode getSyncMode() {
        return this.syncMode;
    }

    public void setSyncMode(SyncMode syncMode) {
        this.syncMode = syncMode;
    }

    @Editable(name="P4 CharSet", order=645, description="Optionally specify the P4CHARSET environment variable used for checkout.")
    @Advanced
    public String getP4charset() {
        return this.p4charset;
    }

    public void setP4charset(String p4charset) {
        this.p4charset = p4charset;
    }

    @Editable(name="Reconcile Before Build", order=648, description="If set to true, the workspace will be reconciled before running build. This option is useful if you want to make sure that workspace is in clean state for next build without recreating the workspace.")
    @Advanced
    public boolean isReconcile() {
        return this.reconcile;
    }

    public void setReconcile(boolean reconcile) {
        this.reconcile = reconcile;
    }

    @Editable(order=650, description="This option only takes effect when the repository is labeled by a label step. In that case, the newly created label will be locked if this option is checked.")
    @ScriptApi(value="Whether or not to lock the newly created label when this repository is labeled by a label step.")
    @Advanced
    public boolean isLockLabel() {
        return this.lockLabel;
    }

    public void setLockLabel(boolean lockLabel) {
        this.lockLabel = lockLabel;
    }

    @Editable(name="Merge with Shelved Changes", order=670, description="Check this to merge code retrieved by this repository with specified shelved changes. This is useful to verify developer's changes before committing to Perforce server. This has the same purpose as proof build, but does not require the developer to install user agent.")
    @Advanced
    public ShelveSupport getShelveSupport() {
        return this.shelveSupport;
    }

    public void setShelveSupport(ShelveSupport shelveSupport) {
        this.shelveSupport = shelveSupport;
    }

    @Editable(order=700, description="Check this to enable proof build for this repository. Use this approach to verify developer's uncommitted changes if you do not want to shelve changes first.")
    @ScriptApi(value="Get proof build support object. Null if proof build support is not enabled for this repository.")
    @Advanced
    public P4ProofBuildSupport getProofBuildSupport() {
        return this.proofBuildSupport;
    }

    public void setProofBuildSupport(P4ProofBuildSupport proofBuildSupport) {
        this.proofBuildSupport = proofBuildSupport;
    }

    @Editable(order=800, description="In case QuickBuild has to reload the unloaded workspace, this option tells from which Perforce edge to load the workspace. Leave empty to always reload from current Perforce server.")
    @Scriptable
    @Advanced
    public String getReloadAddress() {
        return this.reloadAddress;
    }

    public void setReloadAddress(String reloadAddress) {
        this.reloadAddress = reloadAddress;
    }

    @Editable(order=900, description="Specify additional options for Perfoce sync command, for instance, you may specify this field as <i>-r3 -vnet.maxwait=60</i> to have Perforce retry sync for three times and specify network timeout as 60 seconds.")
    @Scriptable
    @Advanced
    public String getAdditionalSyncOptions() {
        return this.additionalSyncOptions;
    }

    public void setAdditionalSyncOptions(String additionalSyncOptions) {
        this.additionalSyncOptions = additionalSyncOptions;
    }

    public File getRootDir() {
        return FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getRootPath());
    }

    private StaticSpec getStaticSpec() {
        if (this.staticSpec == null || this.staticSpec.getMappings().isEmpty()) {
            this.staticSpec = this.getStaticSpecProvider().getStaticSpec();
        }
        return this.staticSpec;
    }

    private File getRevisionFile() {
        return new File(this.getRootDir(), this.getName() + ".revision");
    }

    private void revertWorkspace() {
        Commandline cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword());
        cmdline.addArgLine("-c " + this.getClientName() + " revert -w //...");
        cmdline.execute((OutputStream)new LineConsumer.DebugLogger(), new LineConsumer(){

            public void consume(String line) {
                if (!line.endsWith("not opened on this client.")) {
                    Context.getLogger().warn(line);
                }
            }
        }).checkReturnCode();
    }

    protected void checkoutByRevision(PerforceRevision revision) {
        this.checkoutByRevision(revision, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkoutByRevision(PerforceRevision revision, boolean checkoutForLabel) {
        Commandline cmdline;
        this.setupClient();
        this.revertWorkspace();
        if (this.isReconcile() && !checkoutForLabel) {
            Context.getLogger().info("Reconciling workspace...");
            cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword());
            cmdline.addArgValue("-c").addArgValue(this.getClientName());
            cmdline.addArgLine("clean");
            if (SystemUtils.IS_OS_WINDOWS) {
                cmdline.execute(this.getRootDir(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            } else {
                Commandline shcmd = new Commandline("sh");
                shcmd.addArgValue("-c");
                String shcmdArg = "";
                for (String part : cmdline.getCommandParts()) {
                    shcmdArg = part.contains(" ") ? shcmdArg + "\"" + part + "\" " : shcmdArg + part + " ";
                }
                shcmd.addArgValue(shcmdArg);
                shcmd.execute(this.getRootDir(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            }
            FileUtils.writeFile((File)this.getRevisionFile(), (String)this.getRevision().getValue());
        }
        if (!checkoutForLabel && this.getShelveSupport() != null && this.getShelveSupport().getShelveCondition().satisfied(this)) {
            if (!this.getBuild().isScheduled()) {
                cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword());
                final HashSet allShelved = new HashSet();
                cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword());
                cmdline.addArgLine("changes -s shelved -u").addArgValue(this.getShelveSupport().getUserName());
                cmdline.execute((OutputStream)new LineConsumer(){

                    public void consume(String line) {
                        Context.getLogger().debug(line);
                        if (line.startsWith("Change ")) {
                            line = line.substring("Change ".length());
                            allShelved.add(StringUtils.substringBefore((String)line, (String)" "));
                        }
                    }
                }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
                if (this.getShelveSupport().getShelvedChanges() != null) {
                    this.getShelveSupport().setActualShelvedChanges(new ArrayList<String>());
                    for (String each : StringUtils.splitAndTrim((String)this.getShelveSupport().getShelvedChanges())) {
                        if (allShelved.contains(each)) {
                            this.getShelveSupport().getActualShelvedChanges().add(each);
                            continue;
                        }
                        Context.getLogger().warn("Shelve change '" + each + "' ignored as it " + "does not contain any shelved files.");
                    }
                } else {
                    this.getShelveSupport().setActualShelvedChanges(new ArrayList<String>(allShelved));
                }
                for (String each : this.getShelveSupport().getActualShelvedChanges()) {
                    cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("-c " + this.getClientName()).addArgLine("unshelve -s").addArgValue(each);
                    cmdline.execute((OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
                }
                File shelvedChangesDirOfThisRepo = FileUtils.createTempDir();
                try {
                    this.writeShelvedChanges(shelvedChangesDirOfThisRepo, this.getShelveSupport().getActualShelvedChanges());
                    GridNode localNode = Grid.instance.getLocalNode();
                    GridNode serverNode = Grid.instance.getServerNode();
                    ServerService serverService = Quickbuild.getServerService();
                    String buildPublishDirAtServer = serverService.getBuildPublishDir(Context.getBuild().getId());
                    String shelvedChangesDirAtServer = buildPublishDirAtServer + "/" + SHELVED_CHANGES_DIR;
                    Grid.instance.transferFiles(localNode, shelvedChangesDirOfThisRepo.getAbsolutePath(), "**", serverNode, shelvedChangesDirAtServer + "/" + this.getName(), false, null, shelvedChangesDirAtServer);
                }
                finally {
                    FileUtils.deleteDir((File)shelvedChangesDirOfThisRepo);
                }
            } else {
                Context.getLogger().warn("Shelve support is only applicable for manually triggered builds.");
            }
        }
        cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword());
        if (this.getAdditionalSyncOptions() != null) {
            cmdline.addArgLine(this.getAdditionalSyncOptions());
        }
        cmdline.addArgLine("-c " + this.getClientName()).addArgValue("sync");
        File revisionFile = this.getRevisionFile();
        if (this.getSyncMode() == SyncMode.POPULATE_SYNC) {
            cmdline.addArgValue("-p");
        } else if (this.getSyncMode() == SyncMode.FORCE_SYNC) {
            cmdline.addArgValue("-f");
        } else if (!revisionFile.exists()) {
            cmdline.addArgValue("-f");
        }
        cmdline.addArgValue("@" + (Object)((Object)revision));
        final AtomicBoolean shouldRemoveFromWorkspace = new AtomicBoolean(false);
        Commandline.ExecuteResult result = cmdline.execute((OutputStream)new LineConsumer(){

            public void consume(String line) {
                if (line.contains("can't sync -p a file that's synced")) {
                    shouldRemoveFromWorkspace.set(true);
                    Context.getLogger().warn(line);
                } else {
                    Context.getLogger().debug(line);
                }
            }
        }, new LineConsumer(){

            public void consume(String line) {
                if (line.endsWith("file(s) up-to-date.")) {
                    Context.getLogger().debug(line);
                } else if (line.contains("can't sync -p a file that's synced")) {
                    shouldRemoveFromWorkspace.set(true);
                    Context.getLogger().warn(line);
                } else {
                    Context.getLogger().warn(line);
                }
            }
        });
        if (shouldRemoveFromWorkspace.get()) {
            Context.getLogger().info("Syncing to #0 to remove workspace file status from perforce server...");
            cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("-c " + this.getClientName()).addArgValue("sync");
            cmdline.addArgValue("#0");
            cmdline.execute((OutputStream)new LineConsumer.DebugLogger(), new LineConsumer(){

                public void consume(String line) {
                    if (line.endsWith("file(s) up-to-date.")) {
                        Context.getLogger().debug(line);
                    } else {
                        Context.getLogger().warn(line);
                    }
                }
            }).checkReturnCode();
            cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("-c " + this.getClientName()).addArgValue("sync");
            cmdline.addArgValue("-p");
            cmdline.addArgValue("@" + (Object)((Object)revision));
            cmdline.execute((OutputStream)new LineConsumer.DebugLogger(), new LineConsumer(){

                public void consume(String line) {
                    if (line.endsWith("file(s) up-to-date.")) {
                        Context.getLogger().debug(line);
                    } else {
                        Context.getLogger().warn(line);
                    }
                }
            }).checkReturnCode();
        } else {
            result.checkReturnCode();
        }
        if (this.getShelveSupport() != null && this.getShelveSupport().getActualShelvedChanges() != null && !this.getShelveSupport().getActualShelvedChanges().isEmpty()) {
            Context.getLogger().info("Detecting conflicts...");
            cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("-c " + this.getClientName() + " resolve -am");
            final AtomicBoolean conflictsFound = new AtomicBoolean(false);
            cmdline.execute((OutputStream)new LineConsumer(){

                public void consume(String line) {
                    if (line.endsWith("- resolve skipped.")) {
                        conflictsFound.set(true);
                        Context.getLogger().warn(line);
                    } else {
                        Context.getLogger().debug(line);
                    }
                }
            }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            if (conflictsFound.get()) {
                String changes = StringUtils.join(this.getShelveSupport().getActualShelvedChanges());
                throw new QuickbuildException("Conflicts found while unshelving changes '" + changes + "' from user '" + this.getShelveSupport().getUserName() + "'. Please resolve and re-shelve.");
            }
        }
        FileUtils.writeFile((File)revisionFile, (String)revision.getValue());
    }

    private boolean isPathExcluded(List<Pair<String, Boolean>> paths, String path) {
        for (Pair<String, Boolean> each : paths) {
            if (!FileUtils.matches((String)path.toLowerCase(), (String)((String)each.getFirst()).toLowerCase())) continue;
            return (Boolean)each.getSecond();
        }
        return true;
    }

    private void writeShelvedChanges(File shelvedChangesDirOfThisRepo, List<String> shelvedChangeNumbers) {
        final List<Pair<String, Boolean>> depotPaths = this.getDepotPaths();
        for (String changeNumber : shelvedChangeNumbers) {
            File changeDir = new File(shelvedChangesDirOfThisRepo, changeNumber);
            FileUtils.createDir((File)changeDir);
            Commandline cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("describe -s");
            cmdline.addArgValue(changeNumber);
            final Changeset changeset = new Changeset();
            changeset.setId(changeNumber);
            final Block[] block = new Block[1];
            cmdline.execute((OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    if (line.startsWith("Change")) {
                        StringTokenizer st = new StringTokenizer(line);
                        st.nextToken();
                        st.nextToken();
                        st.nextToken();
                        changeset.setUser(StringUtils.substringBefore((String)st.nextToken(), (String)"@"));
                        st.nextToken();
                        try {
                            changeset.setDate(PerforceRepository.this.getDateTimeFormatter().parseDateTime(st.nextToken() + " " + st.nextToken()).toDate());
                        }
                        catch (IllegalArgumentException e) {
                            Context.getLogger().warn("Error parsing commit date.", (Throwable)e);
                        }
                        changeset.setComment("");
                        block[0] = Block.CHANGE_DESC;
                    } else if (line.startsWith("Jobs fixed ...")) {
                        block[0] = Block.JOBS;
                    } else if (line.startsWith("Affected files ...")) {
                        block[0] = Block.FILES;
                    } else if (!line.startsWith("...") && block[0] != Block.JOBS && block[0] == Block.CHANGE_DESC && line.startsWith("\t")) {
                        String comment = changeset.getComment();
                        if (comment.length() != 0) {
                            comment = comment + "\n";
                        }
                        changeset.setComment(comment + line.substring(1));
                    }
                }
            }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("files @=" + changeNumber);
            cmdline.execute((OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Modification modification = new Modification();
                    modification.setPath(StringUtils.substringBefore((String)line, (String)"#"));
                    String tempStr = StringUtils.substringAfter((String)line, (String)"#");
                    tempStr = StringUtils.substringAfter((String)tempStr, (String)" - ");
                    String action = StringUtils.substringBefore((String)tempStr, (String)" ");
                    if (action.equals("edit") || action.equals("integrate")) {
                        modification.setAction(Modification.Action.MODIFY);
                    } else if (action.equals("delete") || action.equals("move/delete")) {
                        modification.setAction(Modification.Action.DELETE);
                    } else if (action.equals("add") || action.equals("move/add") || action.equals("branch") || action.equals("import")) {
                        modification.setAction(Modification.Action.ADD);
                    } else {
                        Context.getLogger().warn("Unrecognized action: " + action);
                    }
                    if (modification.getAction() != null && !PerforceRepository.this.isPathExcluded(depotPaths, modification.getPath())) {
                        changeset.getModifications().add(modification);
                        if (line.endsWith("(text)")) {
                            modification.setPathType(Modification.PathType.TEXT);
                        } else {
                            modification.setPathType(Modification.PathType.BINARY);
                        }
                    }
                }
            }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            FileUtils.writeFile((File)new File(changeDir, "changeset"), (Serializable)changeset);
            for (Modification modification : changeset.getModifications()) {
                if (modification.getPathType() != Modification.PathType.TEXT) continue;
                cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("print -q -o");
                cmdline.addArgValue(new File(changeDir, PerforceRepository.normalizeRepositoryPath(modification.getPath())).getAbsolutePath());
                cmdline.addArgValue(modification.getPath());
                cmdline.addArgValue("@=" + changeNumber);
                cmdline.execute((OutputStream)new LineConsumer.WarnLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            }
        }
    }

    public static String normalizeRepositoryPath(String repositoryPath) {
        return StringUtils.stripStart((String)repositoryPath, (String)"/");
    }

    private List<Pair<String, Boolean>> getDepotPaths() {
        ArrayList<Pair<String, Boolean>> depotPaths = new ArrayList<Pair<String, Boolean>>();
        for (Mapping mapping : this.getStaticSpec().getMappings()) {
            String antStyleDepotPath = StringUtils.replace((String)mapping.getDepotPath(), (String)"....", (String)"**/*.");
            antStyleDepotPath = StringUtils.replace((String)antStyleDepotPath, (String)"...", (String)"**");
            antStyleDepotPath = StringUtils.replace((String)antStyleDepotPath, (String)"%%1", (String)"*");
            antStyleDepotPath = StringUtils.replace((String)antStyleDepotPath, (String)"%%2", (String)"*");
            antStyleDepotPath = StringUtils.replace((String)antStyleDepotPath, (String)"%%3", (String)"*");
            antStyleDepotPath = StringUtils.replace((String)antStyleDepotPath, (String)"%%4", (String)"*");
            antStyleDepotPath = StringUtils.replace((String)antStyleDepotPath, (String)"%%5", (String)"*");
            antStyleDepotPath = StringUtils.replace((String)antStyleDepotPath, (String)"%%6", (String)"*");
            antStyleDepotPath = StringUtils.replace((String)antStyleDepotPath, (String)"%%7", (String)"*");
            antStyleDepotPath = StringUtils.replace((String)antStyleDepotPath, (String)"%%8", (String)"*");
            antStyleDepotPath = StringUtils.replace((String)antStyleDepotPath, (String)"%%9", (String)"*");
            Pair depotPath = new Pair((Object)antStyleDepotPath, (Object)mapping.isExclude());
            depotPaths.add((Pair<String, Boolean>)depotPath);
        }
        Collections.reverse(depotPaths);
        return depotPaths;
    }

    protected List<Changeset> getChangesBetween(PerforceRevision startRevision, PerforceRevision endRevision) {
        this.setupClient();
        final ArrayList<Changeset> changesets = new ArrayList<Changeset>();
        if (!NumberUtils.isDigits((String)startRevision.getValue()) || !NumberUtils.isDigits((String)endRevision.getValue())) {
            return changesets;
        }
        final HashSet changeNumbers = new HashSet();
        for (Mapping mapping : this.getStaticSpec().getMappings()) {
            if (mapping.isExclude()) continue;
            Commandline cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("-c " + this.getClientName()).addArgLine("changes -s submitted").addArgValue(mapping.getDepotPath() + "@" + (Object)((Object)startRevision) + ",@" + (Object)((Object)endRevision));
            cmdline.execute((OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    changeNumbers.add(st.nextToken());
                }
            }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        }
        changeNumbers.remove(startRevision.getValue());
        if (changeNumbers.isEmpty()) {
            return changesets;
        }
        final List<Pair<String, Boolean>> depotPaths = this.getDepotPaths();
        Iterator it = changeNumbers.iterator();
        int count = 0;
        Commandline cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("describe -s");
        while (it.hasNext()) {
            String changeNumber = (String)it.next();
            cmdline.addArgValue(changeNumber);
            if (++count < 25 && (it.hasNext() || count == 0)) continue;
            final Changeset[] changeset = new Changeset[]{null};
            final Block[] block = new Block[1];
            cmdline.execute((OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    if (line.startsWith("Change")) {
                        if (changeset[0] != null) {
                            changesets.add(changeset[0]);
                        }
                        changeset[0] = new Changeset();
                        StringTokenizer st = new StringTokenizer(line);
                        st.nextToken();
                        changeset[0].setId(st.nextToken());
                        st.nextToken();
                        changeset[0].setUser(StringUtils.substringBefore((String)st.nextToken(), (String)"@"));
                        st.nextToken();
                        try {
                            changeset[0].setDate(PerforceRepository.this.getDateTimeFormatter().parseDateTime(st.nextToken() + " " + st.nextToken()).toDate());
                        }
                        catch (IllegalArgumentException e) {
                            Context.getLogger().warn("Error parsing commit date.", (Throwable)e);
                        }
                        changeset[0].setComment("");
                        block[0] = Block.CHANGE_DESC;
                    } else if (line.startsWith("Jobs fixed ...")) {
                        block[0] = Block.JOBS;
                        String comment = changeset[0].getComment();
                        if (comment.length() != 0) {
                            comment = comment + "\n\n";
                        }
                        changeset[0].setComment(comment + "===== Jobs (appended by QuickBuild) ======");
                    } else if (line.startsWith("Affected files ...")) {
                        block[0] = Block.FILES;
                    } else if (line.startsWith("...")) {
                        Modification modification = new Modification();
                        String tempStr = StringUtils.substringAfter((String)line, (String)"... ");
                        modification.setPath(StringUtils.substringBefore((String)tempStr, (String)"#"));
                        tempStr = StringUtils.substringAfter((String)tempStr, (String)"#");
                        modification.setEdition("#" + StringUtils.substringBefore((String)tempStr, (String)" "));
                        String action = StringUtils.substringAfter((String)tempStr, (String)" ");
                        if (action.equals("edit") || action.equals("integrate")) {
                            modification.setAction(Modification.Action.MODIFY);
                            modification.setPreviousEdition("#" + String.valueOf(Integer.parseInt(modification.getEdition().substring(1)) - 1));
                        } else if (action.equals("delete") || action.equals("move/delete")) {
                            modification.setAction(Modification.Action.DELETE);
                        } else if (action.equals("add") || action.equals("move/add") || action.equals("branch") || action.equals("import")) {
                            modification.setAction(Modification.Action.ADD);
                        } else {
                            Context.getLogger().warn("Unrecognized action: " + action);
                        }
                        if (modification.getAction() != null && !PerforceRepository.this.isPathExcluded(depotPaths, modification.getPath())) {
                            changeset[0].getModifications().add(modification);
                        }
                    } else if (block[0] == Block.JOBS) {
                        changeset[0].setComment(changeset[0].getComment() + "\n" + line);
                        if (line.trim().length() != 0 && !line.startsWith("\t") && line.endsWith("*closed*")) {
                            changeset[0].getClosedTasks().add(StringUtils.substringBefore((String)line, (String)" "));
                        }
                    } else if (block[0] == Block.CHANGE_DESC && line.startsWith("\t")) {
                        String comment = changeset[0].getComment();
                        if (comment.length() != 0) {
                            comment = comment + "\n";
                        }
                        changeset[0].setComment(comment + line.substring(1));
                    }
                }
            }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            if (changeset[0] != null) {
                changesets.add(changeset[0]);
            }
            count = 0;
            cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword());
            cmdline.createArgument().setLine("describe -s");
        }
        return changesets;
    }

    File getCheckoutFile(String clientName, String repositoryPath, String userName, String password) {
        Commandline cmdline = this.buildP4Cmd(userName, password).addArgLine("-c " + clientName).addArgValue("where").addArgValue(repositoryPath);
        final File[] file = new File[]{null};
        Commandline.ExecuteResult result = cmdline.execute((OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                if (!line.startsWith("-")) {
                    line = StringUtils.substringAfter((String)line, (String)" //");
                    line = StringUtils.substringAfter((String)line, (String)" ");
                    while (StringUtils.isNotBlank((String)line) && !new File(line).isAbsolute()) {
                        line = StringUtils.substringAfter((String)line, (String)" ");
                    }
                    if (StringUtils.isNotBlank((String)line)) {
                        file[0] = new File(line);
                    }
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger());
        if (result.getReturnCode() == 0) {
            return file[0];
        }
        return null;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        if (this.dateTimeFormatter == null) {
            this.dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm:ss");
            try {
                this.dateTimeFormatter = this.dateTimeFormatter.withZone(this.getServerTimeZone());
            }
            catch (Exception e) {
                Context.getLogger().error("Error detecting server timezone.", (Throwable)e);
            }
        }
        return this.dateTimeFormatter;
    }

    public DateTimeZone getServerTimeZone() {
        if (this.serverTimeZone == null) {
            Commandline cmd = this.buildP4Cmd(this.getUserName(), this.getPassword());
            cmd.addArgValue("info");
            cmd.execute((OutputStream)new LineConsumer(){

                public void consume(String line) {
                    if (line.startsWith("Server date:")) {
                        StringTokenizer tokenizer = new StringTokenizer(line);
                        tokenizer.nextToken();
                        tokenizer.nextToken();
                        tokenizer.nextToken();
                        tokenizer.nextToken();
                        String timeZone = tokenizer.nextToken();
                        try {
                            PerforceRepository.this.serverTimeZone = DateTimeZone.forID((String)timeZone);
                        }
                        catch (Exception e) {
                            Context.getLogger().error("Error detecting server timezone, using default", (Throwable)e);
                            PerforceRepository.this.serverTimeZone = DateTimeZone.getDefault();
                        }
                    }
                }
            }, new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().warn(line);
                }
            }).checkReturnCode();
        }
        return this.serverTimeZone;
    }

    public boolean isClientSynced() {
        Date time;
        if (this.clientSyncTime == null) {
            this.clientSyncTime = new HashMap<String, Date>();
        }
        return (time = this.clientSyncTime.get(Grid.instance.getLocalNode().getAddress())) != null;
    }

    private void setClientSynced() {
        if (this.clientSyncTime == null) {
            this.clientSyncTime = new HashMap<String, Date>();
        }
        this.clientSyncTime.put(Grid.instance.getLocalNode().getAddress(), new Date());
    }

    @ScriptApi(value="Set up the Perforce client for this repository at current node.")
    public void setupClient() {
        if (!this.isClientSynced()) {
            String clientName = this.getClientName();
            Context.getLogger().info("Updating client spec of '" + clientName + "'...");
            StaticSpec staticSpec = this.getStaticSpec();
            Commandline cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("-c " + clientName + " client -i");
            StringBuffer buffer = new StringBuffer();
            buffer.append("Client: ").append(clientName).append("\n");
            buffer.append("Owner: ").append(this.getUserName()).append("\n");
            GridNode node = ((Grid)Quickbuild.getInstance(Grid.class)).getLocalNode();
            buffer.append("Host: ").append(node.getHostName()).append("\n");
            buffer.append("Root: ").append(this.getRootDir().getAbsolutePath()).append("\n");
            buffer.append("SubmitOptions: ").append(staticSpec.getSubmitOptions()).append("\n");
            buffer.append("Options: ").append(staticSpec.getOptions()).append("\n");
            buffer.append("LineEnd: ").append(staticSpec.getLineEnd()).append("\n");
            if (staticSpec.getServerId() != null) {
                buffer.append("ServerID: ").append(staticSpec.getServerId()).append("\n");
            }
            buffer.append("Description:\n");
            buffer.append("\tCreated by QuickBuild for purpose of running configuration '" + Context.getConfiguration().getPathName() + "'.").append("\n");
            if (!this.getStaticSpec().getMappings().isEmpty()) {
                buffer.append("View:\n");
                for (Mapping mapping : this.getStaticSpec().getMappings()) {
                    buffer.append("\t");
                    if (mapping.getDepotPath().indexOf(32) != -1) {
                        buffer.append("\"");
                    }
                    if (mapping.isOverlay()) {
                        buffer.append("+");
                    } else if (mapping.isExclude()) {
                        buffer.append("-");
                    }
                    buffer.append(mapping.getDepotPath());
                    if (mapping.getDepotPath().indexOf(32) != -1) {
                        buffer.append("\"");
                    }
                    buffer.append(" ");
                    if (mapping.getClientPath().indexOf(32) != -1) {
                        buffer.append('\"');
                    }
                    buffer.append(mapping.getClientPath());
                    if (mapping.getClientPath().indexOf(32) != -1) {
                        buffer.append('\"');
                    }
                    buffer.append("\n");
                }
            }
            if (this.getStaticSpec().getStream() != null) {
                buffer.append("Stream: ").append(staticSpec.getStream()).append("\n");
            }
            Context.getLogger().debug("Client spec:\n" + buffer.toString());
            final AtomicBoolean unloaded = new AtomicBoolean(false);
            Commandline.ExecuteResult result = cmdline.execute((OutputStream)new LineConsumer.DebugLogger(), new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().warn(line);
                    if (line.contains("has been unloaded, and must be reloaded to be used")) {
                        unloaded.set(true);
                    }
                }
            }, buffer.toString());
            if (unloaded.get()) {
                Context.getLogger().info("Client {} has been unloaded, trying to reload it...", (Object)clientName);
                cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("reload -c").addArgValue(clientName);
                if (this.getReloadAddress() != null) {
                    cmdline.addArgValue("-p").addArgValue(this.getReloadAddress());
                }
                cmdline.execute((OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
                this.setupClient();
            } else {
                result.checkReturnCode();
            }
            this.setClientSynced();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished() {
        super.buildFinished();
        if (this.getShelveSupport() == null || this.getShelveSupport().getActualShelvedChanges() == null || this.getShelveSupport().getActualShelvedChanges().isEmpty()) {
            return;
        }
        try {
            if (((Boolean)((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getShelveSupport().getSubmitCondition(), Context.buildEvalContext((Object)((Object)this), null))).booleanValue()) {
                Context.getLogger().info("Submitting shelved changes...");
                for (String changeNumber : this.getShelveSupport().getActualShelvedChanges()) {
                    Commandline cmdline = this.buildP4Cmd(this.getShelveSupport().getUserName(), this.getShelveSupport().getPassword());
                    cmdline.addArgLine("-c " + this.getClientName() + " submit");
                    cmdline.addArgLine("-e " + changeNumber);
                    final AtomicBoolean nonStreamError = new AtomicBoolean(false);
                    Commandline.ExecuteResult result = cmdline.execute((OutputStream)new LineConsumer(){

                        public void consume(String line) {
                            if (line.endsWith("warning: cannot submit from non-stream client")) {
                                nonStreamError.set(true);
                                Context.getLogger().error(line);
                            } else {
                                Context.getLogger().debug(line);
                            }
                        }
                    }, (LineConsumer)new LineConsumer.WarnLogger());
                    if (nonStreamError.get()) {
                        throw new QuickbuildException("Cannot submit from non-stream client: " + this.getClientName());
                    }
                    result.checkReturnCode();
                }
                this.getShelveSupport().setActualShelvedChanges(null);
            }
        }
        finally {
            if (this.getShelveSupport().getRevertOption() == ShelveSupport.RevertOption.REVERT_AFTER_CURRENT_BUILD || this.getShelveSupport().getRevertOption() == ShelveSupport.RevertOption.REVERT_AFTER_CURRNT_BUILD_IF_SUCCESSFUL && (this.getBuild().isSuccessful() || this.getBuild().isRecommended())) {
                this.revertWorkspace();
            }
        }
    }

    protected PerforceRevision getHeadRevision() {
        this.setupClient();
        if (this.getBuildRevision() != null) {
            return new PerforceRevision(this.getBuildRevision());
        }
        Commandline cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("changes -s submitted -m 1");
        for (Mapping mapping : this.getStaticSpec().getMappings()) {
            if (mapping.isExclude()) continue;
            cmdline.addArgValue(mapping.getDepotPath());
        }
        final ArrayList changeNumbers = new ArrayList();
        cmdline.execute((OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                StringTokenizer st = new StringTokenizer(line);
                st.nextToken();
                changeNumbers.add(Integer.valueOf(st.nextToken()));
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        if (!changeNumbers.isEmpty()) {
            return new PerforceRevision(String.valueOf(Collections.max(changeNumbers)));
        }
        throw new QuickbuildException("No head change numbers found.");
    }

    private boolean labelExists(final String label) {
        final AtomicBoolean labelExist = new AtomicBoolean(false);
        Commandline cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("labels");
        cmdline.execute((OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                if (line.trim().startsWith("Label " + label)) {
                    labelExist.set(true);
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        return labelExist.get();
    }

    private List<String> readLabelView(String label) {
        final ArrayList<String> view = new ArrayList<String>();
        Commandline cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("label -o").addArgValue(label);
        cmdline.execute((OutputStream)new LineConsumer(){
            private Perl5Util util = new Perl5Util();
            private boolean inViewBlock = false;

            public void consume(String line) {
                Context.getLogger().debug(line);
                if (this.inViewBlock) {
                    if (!this.util.match("/^\\s/", line)) {
                        this.inViewBlock = false;
                    } else if ((line = line.trim()).startsWith("\"") && line.endsWith("\"")) {
                        view.add(line.substring(1, line.length() - 1));
                    } else {
                        view.add(line);
                    }
                } else if (view.isEmpty() && this.util.match("/^View:/", line)) {
                    this.inViewBlock = true;
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        return view;
    }

    protected void labelOnRevision(PerforceRevision revision, String label, String comment) {
        this.setupClient();
        Context.getLogger().info("Labeling repository (revision: {}, label: {})", (Object)revision.getValue(), (Object)label);
        this.editLabel(label, comment, false);
        File revisionFile = this.getRevisionFile();
        if (!revisionFile.exists() || !FileUtils.readFileAsString((File)revisionFile).equals((Object)revision)) {
            Context.getLogger().info("Updating client to revision '" + (Object)((Object)revision) + "' before syncing label...");
            if (this.isLocalChangeApplied()) {
                this.revertLocalChange();
            }
            this.checkoutByRevision(revision, true);
        }
        Commandline cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgValue("-c").addArgValue(this.getClientName()).addArgLine("labelsync -a -l").addArgValue(label);
        cmdline.execute((OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        if (this.isLockLabel()) {
            this.editLabel(label, comment, true);
        }
    }

    private void editLabel(String label, String comment, boolean locked) {
        Commandline cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("label -i");
        StringBuffer buffer = new StringBuffer();
        if (label.contains(" ")) {
            buffer.append("Label: \"" + label + "\"\n");
        } else {
            buffer.append("Label: " + label + "\n");
        }
        buffer.append("Owner: " + this.getUserName() + "\n");
        buffer.append("Description:\n");
        for (String line : StringUtils.split((String)comment, (String)"\n")) {
            buffer.append("\t" + line + "\n");
        }
        if (locked) {
            buffer.append("Options: locked\n");
        } else {
            buffer.append("Options: unlocked\n");
        }
        buffer.append("View:\n");
        List<String> view = this.labelExists(label) ? this.readLabelView(label) : new ArrayList<String>();
        for (Mapping mapping : this.getStaticSpec().getMappings()) {
            if (view.contains(mapping.getDepotPath())) continue;
            view.add(mapping.getDepotPath());
        }
        for (String line : view) {
            buffer.append("\t");
            if (line.contains(" ")) {
                buffer.append("\"" + line + "\"");
            } else {
                buffer.append(line);
            }
            buffer.append("\n");
        }
        Context.getLogger().debug("Label spec:\n" + buffer.toString());
        cmdline.execute((OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger(), buffer.toString()).checkReturnCode();
    }

    @ScriptApi(value="Get Perforce ticket of specified user name and password for current workspace.")
    public String getTicket(final String userName, String password) {
        if (this.tickets == null) {
            this.tickets = new HashMap<String, String>();
        }
        if (this.tickets.get(userName) == null) {
            Context.getLogger().debug("Getting Perforce ticket...");
            Commandline cmdline = new Commandline();
            String p4Exe = this.getPerforceSetting().getP4ExePath();
            if (p4Exe == null) {
                p4Exe = "p4";
            }
            cmdline.setExecutable(p4Exe).addArgValue("-p").addArgValue(this.getPort()).addArgValue("-u").addArgValue(userName);
            if (this.getP4charset() != null) {
                cmdline.addArgValue("-C").addArgValue(this.getP4charset());
            }
            cmdline.addArgLine("login -p");
            cmdline.execute((OutputStream)new LineConsumer(){

                public void consume(String line) {
                    PerforceRepository.this.tickets.put(userName, line);
                }
            }, (LineConsumer)new LineConsumer.ErrorLogger(), password).checkReturnCode();
        }
        return this.tickets.get(userName);
    }

    @ScriptApi(value="Get Perforce ticket of specified user name and password for all workspaces.")
    public String getTicketForAll(String userName, String password) {
        Commandline cmdline = new Commandline();
        String p4Exe = this.getPerforceSetting().getP4ExePath();
        if (p4Exe == null) {
            p4Exe = "p4";
        }
        cmdline.setExecutable(p4Exe).addArgValue("-p").addArgValue(this.getPort()).addArgValue("-u").addArgValue(userName);
        if (this.getP4charset() != null) {
            cmdline.addArgValue("-C").addArgValue(this.getP4charset());
        }
        cmdline.addArgLine("login -p -a");
        final AtomicReference ticketRef = new AtomicReference();
        cmdline.execute((OutputStream)new LineConsumer(){

            public void consume(String line) {
                ticketRef.set(line);
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger(), password).checkReturnCode();
        return (String)ticketRef.get();
    }

    private PerforceSetting getPerforceSetting() {
        return (PerforceSetting)PluginSettingHelper.getSetting(PerforcePlugin.class, (boolean)true);
    }

    Commandline buildP4Cmd(final String userName, final String password) {
        Commandline cmdline = new Commandline(new SecretMasker(){

            public String mask(String message) {
                if (password != null) {
                    String ticket = PerforceRepository.this.getTicket(userName, password);
                    return StringUtils.replace((String)message, (String)("-P " + this.quoteIfNecessary(ticket)), (String)"-P ******");
                }
                return message;
            }
        });
        String p4Exe = this.getPerforceSetting().getP4ExePath();
        if (p4Exe == null) {
            p4Exe = "p4";
        }
        cmdline.setExecutable(p4Exe);
        cmdline.addArgValue("-p").addArgValue(this.getPort());
        if (userName != null) {
            cmdline.addArgValue("-u").addArgValue(userName);
            if (password != null) {
                cmdline.addArgValue("-P").addArgValue(this.getTicket(userName, password));
            }
        }
        if (this.getP4charset() != null) {
            cmdline.addArgValue("-C").addArgValue(this.getP4charset());
        }
        return cmdline;
    }

    public SourceViewSupport<PerforceRevision> getSourceViewSupport() {
        return new P4SourceViewSupport(this);
    }

    protected boolean isQuietSince(Date date) {
        this.setupClient();
        List<Mapping> mappings = this.getStaticSpec().getMappings();
        for (Mapping mapping : mappings) {
            if (mapping.isExclude()) continue;
            Commandline cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("changes -s submitted").addArgValue(mapping.getDepotPath() + "@" + this.getDateTimeFormatter().print((ReadableInstant)new DateTime((Object)date)) + ",@" + this.getDateTimeFormatter().print((ReadableInstant)new DateTime()));
            final AtomicBoolean changed = new AtomicBoolean(false);
            cmdline.execute((OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    changed.set(true);
                }
            }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            if (!changed.get()) continue;
            return false;
        }
        return true;
    }

    protected RevisionInfo getRevisionInfo(PerforceRevision revision) {
        if (!NumberUtils.isDigits((String)revision.getValue())) {
            return null;
        }
        final RevisionInfo info = new RevisionInfo();
        Commandline cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword());
        cmdline.createArgument().setLine("-q describe -s");
        cmdline.createArgument().setValue(revision.getValue());
        final AtomicReference block = new AtomicReference();
        cmdline.execute((OutputStream)new LineConsumer(){

            public void consume(String line) {
                if (line.startsWith("Change")) {
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    info.setCommitter(StringUtils.substringBefore((String)st.nextToken(), (String)"@"));
                    st.nextToken();
                    info.setComment("");
                    block.set(Block.CHANGE_DESC);
                } else if (line.startsWith("Jobs fixed ...")) {
                    block.set(Block.JOBS);
                } else if (line.startsWith("Affected files ...")) {
                    block.set(Block.FILES);
                } else if (block.get() == Block.CHANGE_DESC && line.startsWith("\t")) {
                    String comment = info.getComment();
                    if (comment.length() != 0) {
                        comment = comment + "\n";
                    }
                    info.setComment(comment + line.substring(1));
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        return info;
    }

    public String getEmail(String committer) {
        Commandline cmdline = this.buildP4Cmd(this.getUserName(), this.getPassword()).addArgLine("user -o").addArgValue(committer);
        final String[] email = new String[1];
        cmdline.execute((OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                if (line.startsWith("Email:")) {
                    email[0] = line.substring(6).trim();
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        if (StringUtils.isNotBlank((String)email[0])) {
            return email[0];
        }
        return null;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("lockLabel").setText("false");
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        Element revisionElement = dom.getRootElement().element("revision");
        if (revisionElement != null) {
            revisionElement.setName("buildRevision");
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        if (dom.getRootElement().element("clientName") == null) {
            dom.getRootElement().addElement("clientName").setText("qb-${node.hostName}-${current.rootDirId}");
        }
    }

    private void migrate4(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate5(VersionedDocument dom, Stack<Integer> versions) {
        Element clientNameElement = dom.getRootElement().element("clientName");
        clientNameElement.setName("clientNameProvider");
        String clientName = clientNameElement.getText().trim();
        clientNameElement.clearContent();
        clientNameElement.addElement("repository").addAttribute("reference", "../..");
        if (clientName.equals("qb-${node.hostName}-${current.rootDirId}")) {
            clientNameElement.addAttribute("class", "com.pmease.quickbuild.plugin.scm.perforce.NodeAndDirBasedClientName");
        } else {
            clientNameElement.addAttribute("class", "com.pmease.quickbuild.plugin.scm.perforce.SpecifiedClientName").addElement("clientName").setText(clientName);
        }
        Element staticSpecProviderElement = dom.getRootElement().element("staticSpecProvider");
        String clazz = staticSpecProviderElement.attributeValue("class");
        clazz = clazz.replace("InputStaticSpecProvider", "SpecifiedStaticSpecProvider");
        staticSpecProviderElement.attribute("class").setValue(clazz);
    }

    private void migrate6(VersionedDocument dom, Stack<Integer> versions) {
        Element proofBuildSupportElement = dom.getRootElement().element("proofBuildSupport");
        if (proofBuildSupportElement != null) {
            proofBuildSupportElement.addElement("proofCondition").addAttribute("class", "com.pmease.quickbuild.setting.repository.proofcondition.AlwaysProof");
        }
    }

    private void migrate7(VersionedDocument dom, Stack<Integer> versions) {
        Element staticSpecProviderElement = dom.getRootElement().element("staticSpecProvider");
        if (staticSpecProviderElement.attributeValue("class").contains("SpecifiedStaticSpecProvider")) {
            staticSpecProviderElement.addElement("submitOptions").setText("submitunchanged");
        }
    }

    private void migrate8(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("forceSync").setText("false");
    }

    private void migrate9(VersionedDocument dom, Stack<Integer> versions) {
        Element forceSyncElement = dom.getRootElement().element("forceSync");
        String forceSync = forceSyncElement.getText().trim();
        if (forceSync.equals("true") || forceSync.equals("yes")) {
            dom.getRootElement().addElement("syncMode").setText("FORCE_SYNC");
        } else {
            dom.getRootElement().addElement("syncMode").setText("NORMAL_SYNC");
        }
        forceSyncElement.detach();
    }

    private void migrate10(VersionedDocument dom, Stack<Integer> versions) {
        Element shelveSupportElement = dom.getRootElement().element("shelveSupport");
        if (shelveSupportElement != null) {
            shelveSupportElement.addElement("shelveCondition").addAttribute("class", "com.pmease.quickbuild.plugin.scm.perforce.shelvecondition.AlwaysShelve");
        }
    }

    private void migrate11(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("reconcile").setText("false");
    }

    private void migrate12(VersionedDocument dom, Stack<Integer> versions) {
        Element shelveSupportElement = dom.getRootElement().element("shelveSupport");
        if (shelveSupportElement != null) {
            Element commitIfSuccessfulElement = shelveSupportElement.element("commitIfSuccessful");
            if (commitIfSuccessfulElement.getTextTrim().equals("true")) {
                shelveSupportElement.addElement("submitCondition").setText("build.successful");
            } else {
                shelveSupportElement.addElement("submitCondition").setText("false");
            }
            commitIfSuccessfulElement.detach();
        }
    }

    private void migrate13(VersionedDocument dom, Stack<Integer> versions) {
        Element shelveSupportElement = dom.getRootElement().element("shelveSupport");
        if (shelveSupportElement != null) {
            shelveSupportElement.addElement("revertOption").setText("REVERT_BEFORE_NEXT_BUILD");
        }
    }

    public static enum SyncMode {
        NORMAL_SYNC,
        FORCE_SYNC,
        POPULATE_SYNC;

    }

    private static enum Block {
        CHANGE_DESC,
        JOBS,
        FILES;

    }
}

