/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.perforce;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.perforce.PerforceRepository;
import com.pmease.quickbuild.plugin.scm.perforce.PerforceRevision;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.List;

public class P4SourceViewSupport
extends SourceViewSupport<PerforceRevision> {
    public P4SourceViewSupport(PerforceRepository repository) {
        super((Repository)repository);
    }

    public PerforceRepository getRepository() {
        return (PerforceRepository)super.getRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readSourceByRevision(String repositoryPath, PerforceRevision revision) {
        Commandline cmdline = this.getRepository().buildP4Cmd(this.getRepository().getUserName(), this.getRepository().getPassword());
        File tempFile = FileUtils.createTempFile((String)"p4sourceview");
        try {
            cmdline.addArgLine("print -q -o").addArgValue(tempFile.getAbsolutePath()).addArgValue(repositoryPath + "@" + (Object)((Object)revision));
            cmdline.execute((OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            List list = FileUtils.readFileAsLines((File)tempFile);
            return list;
        }
        finally {
            FileUtils.deleteFile((File)tempFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readSourceByEdition(String repositoryPath, String edition) {
        Commandline cmdline = this.getRepository().buildP4Cmd(this.getRepository().getUserName(), this.getRepository().getPassword());
        File tempFile = FileUtils.createTempFile((String)"p4sourceview");
        try {
            cmdline.addArgLine("print -q -o").addArgValue(tempFile.getAbsolutePath()).addArgValue(repositoryPath + edition);
            cmdline.execute((OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            List list = FileUtils.readFileAsLines((File)tempFile);
            return list;
        }
        finally {
            FileUtils.deleteFile((File)tempFile);
        }
    }

    public String getRepositoryPath(String checkoutPath) {
        this.getRepository().setupClient();
        Commandline cmdline = this.getRepository().buildP4Cmd(this.getRepository().getUserName(), this.getRepository().getPassword());
        cmdline.addArgLine("-c " + this.getRepository().getClientNameProvider().getClientName()).addArgValue("where");
        File checkoutFile = new File(Context.getConfiguration().getWorkspaceDir(), checkoutPath);
        cmdline.addArgValue(checkoutFile.getAbsolutePath());
        final String[] path = new String[]{null};
        Commandline.ExecuteResult result = cmdline.execute((OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                path[0] = StringUtils.substringBeforeLast((String)line, (String)"//").trim();
            }
        }, (LineConsumer)new LineConsumer.WarnLogger());
        if (result.getReturnCode() == 0) {
            return path[0];
        }
        return null;
    }
}

