/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.perforce;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.perforce.PerforceLocalChange;
import com.pmease.quickbuild.plugin.scm.perforce.PerforceRepository;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi
public class P4ProofBuildSupport
extends ProofBuildSupport<PerforceLocalChange> {
    private PerforceRepository repository;
    private String clientName;
    private String userName;
    private String password;
    private String syncCondition = "true";
    private String changeNumbers;
    private String submitCondition = "build.successful";
    private String submitComment;

    @Editable(order=100, name="Local Client", description="Specify name of client at user's desktop. Pending changes will be collected from this client and send to build grid to run a proof build.")
    @NotEmpty
    @ScriptApi(value="Get name of the local client.")
    @Scriptable
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Editable(order=110, description="Optionally specify perforce user name to be used at user's desktop.")
    @ScriptApi(value="Get user name to be used at user's desktop.")
    @Scriptable
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=120, description="Specify perforce password to be used at user's desktop.")
    @Password
    @ScriptApi(value="Get password to be used at user's desktop.")
    @Scriptable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(order=200, description="Specify the condition to sync local client. If this condition is satisfied, the client specified above will be synced before local change is collected. Syncing client will make the proof build more accurate and you should normally set this condition to <b>true</b>.")
    @Expressions(value={"always sync", "true", "do not sync", "false"})
    @NotEmpty
    @ScriptApi(value="Get the condition to sync local client before collect local change.")
    @Scriptable
    public String getSyncCondition() {
        return this.syncCondition;
    }

    public void setSyncCondition(String syncCondition) {
        this.syncCondition = syncCondition;
    }

    @Editable(name="Change Numbers to Verify", order=250, description="Optionally specify pending change numbers for verification. Multiple change numbers need to be separated by white space, comma character, or line separator. If left empty, all pending changes will be verified.<br><b>NOTE:</b> Enter <i>default</i> for the default change number.")
    @ScriptApi(value="Get pending change lists for verification. Null to verify all pending change lists.")
    @Scriptable
    public String getChangeNumbers() {
        return this.changeNumbers;
    }

    public void setChangeNumbers(String changeNumbers) {
        this.changeNumbers = changeNumbers;
    }

    @Editable(order=300, description="Specify the condition to submit local change. If this condition is satisfied, local change in the workspace specified above will be submitted after the build finishes. Please note that if verification change numbers are specified above, QuickBuild will only submit those change numbers.")
    @Expressions(value={"submit only when build is successful", "build.successful", "always submit", "true", "do not submit", "false"})
    @NotEmpty
    @ScriptApi(value="Get the condition to submit local change after build finishes.")
    @Scriptable
    public String getSubmitCondition() {
        return this.submitCondition;
    }

    public void setSubmitCondition(String submitCondition) {
        this.submitCondition = submitCondition;
    }

    @Editable(order=400, description="Specify the comment when submit the local change. This property only takes effect if the submit condition specified above is satisfied.")
    @Multiline
    @ScriptApi(value="Get comment to submit local change after build finishes. Null if not specified.")
    @Scriptable
    public String getSubmitComment() {
        return this.submitComment;
    }

    public void setSubmitComment(String submitComment) {
        this.submitComment = submitComment;
    }

    public P4ProofBuildSupport(PerforceRepository repository) {
        this.repository = repository;
    }

    private Commandline buildP4Cmd() {
        return this.repository.buildP4Cmd(this.getUserName(), this.getPassword());
    }

    public void buildFinished() {
        Boolean isSubmit = (Boolean)((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getSubmitCondition(), Context.buildEvalContext((Object)((Object)this), null));
        if (isSubmit.booleanValue()) {
            Commandline cmdline = this.buildP4Cmd();
            cmdline.addArgLine("-c " + this.getClientName() + " opened");
            final Set<String> verifyChangeNumbers = this.getVerifyChangeNumbers();
            final HashSet pendings = new HashSet();
            cmdline.execute((OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    StringTokenizer tokenizer = new StringTokenizer(StringUtils.substringAfter((String)line, (String)"#"));
                    tokenizer.nextToken();
                    tokenizer.nextToken();
                    tokenizer.nextToken();
                    tokenizer.nextToken();
                    String changeNumber = tokenizer.nextToken();
                    if (changeNumber.equals("change")) {
                        changeNumber = "default";
                    }
                    if (verifyChangeNumbers.isEmpty() || verifyChangeNumbers.contains(changeNumber)) {
                        pendings.add(changeNumber);
                    }
                }
            }, new LineConsumer(){

                public void consume(String line) {
                    if (!line.contains("File(s) not opened on this client")) {
                        Context.getLogger().warn(line);
                    }
                }
            }).checkReturnCode();
            for (String changeNumber : pendings) {
                cmdline = this.buildP4Cmd();
                cmdline.addArgLine("-c " + this.getClientName() + " submit");
                if (changeNumber.equals("default")) {
                    cmdline.addArgValue("-d");
                    if (this.getSubmitComment() != null) {
                        cmdline.addArgValue(this.getSubmitComment());
                    } else {
                        cmdline.addArgValue("Submitted by QuickBuild as result of proof build.");
                    }
                } else {
                    cmdline.addArgLine("-c " + changeNumber);
                }
                cmdline.execute((OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            }
        }
    }

    public File getCheckoutFile(String repositoryPath) {
        return this.repository.getCheckoutFile(this.repository.getClientNameProvider().getClientName(), repositoryPath, this.getUserName() != null ? this.getUserName() : this.repository.getUserName(), this.getPassword() != null ? this.getPassword() : this.repository.getPassword());
    }

    public PerforceLocalChange getLocalChange(File changeStoreDir) {
        Commandline cmdline;
        Boolean isSync = (Boolean)((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getSyncCondition(), Context.buildEvalContext((Object)((Object)this.repository), null));
        if (isSync.booleanValue()) {
            Context.getLogger().info("Syncing local client...");
            cmdline = this.buildP4Cmd().addArgLine("-c " + this.getClientName() + " sync");
            cmdline.execute((OutputStream)new LineConsumer.DebugLogger(), new LineConsumer(){

                public void consume(String line) {
                    if (line.endsWith("File(s) up-to-date.")) {
                        Context.getLogger().debug(line);
                    } else {
                        Context.getLogger().warn(line);
                    }
                }
            }).checkReturnCode();
        }
        Context.getLogger().info("Detecting conflicts...");
        cmdline = this.buildP4Cmd().addArgLine("-c " + this.getClientName() + " resolve -n");
        final boolean[] conflictsFound = new boolean[]{true};
        cmdline.execute((OutputStream)new LineConsumer.DebugLogger(), new LineConsumer(){

            public void consume(String line) {
                if (line.startsWith("No file(s) to resolve.")) {
                    conflictsFound[0] = false;
                    Context.getLogger().debug(line);
                } else {
                    Context.getLogger().warn(line);
                }
            }
        }).checkReturnCode();
        if (conflictsFound[0]) {
            throw new QuickbuildException("Conflicts found in local client. Please resolve them first.");
        }
        Context.getLogger().info("Checking opened files...");
        PerforceLocalChange change = new PerforceLocalChange();
        cmdline = this.buildP4Cmd().addArgLine("-c " + this.getClientName() + " opened");
        final HashMap opened = new HashMap();
        final Set<String> verifyChangeNumbers = this.getVerifyChangeNumbers();
        cmdline.execute((OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                String path = StringUtils.substringBefore((String)line, (String)"#");
                StringTokenizer tokenizer = new StringTokenizer(StringUtils.substringAfter((String)line, (String)"#"));
                tokenizer.nextToken();
                tokenizer.nextToken();
                String action = tokenizer.nextToken();
                tokenizer.nextToken();
                String changeNumber = tokenizer.nextToken();
                if (changeNumber.equals("change")) {
                    changeNumber = "default";
                }
                if (verifyChangeNumbers.isEmpty() || verifyChangeNumbers.contains(changeNumber)) {
                    opened.put(path, action);
                }
            }
        }, new LineConsumer(){

            public void consume(String line) {
                if (!line.contains("File(s) not opened on this client")) {
                    Context.getLogger().warn(line);
                }
            }
        }).checkReturnCode();
        for (Map.Entry entry : opened.entrySet()) {
            String path = (String)entry.getKey();
            String action = (String)entry.getValue();
            File clientFile = this.repository.getCheckoutFile(this.getClientName(), path, this.getUserName() != null ? this.getUserName() : this.repository.getUserName(), this.getPassword() != null ? this.getPassword() : this.repository.getPassword());
            if (clientFile == null) {
                throw new QuickbuildException("Can not get corresponding client path for depot path: " + path);
            }
            if (action.equals("add") || action.equals("branch") || action.equals("move/add")) {
                change.getAddPaths().add(path);
                FileUtils.copyFile((File)clientFile, (File)new File(changeStoreDir, path.substring(1)));
                continue;
            }
            if (action.equals("delete") || action.equals("move/delete")) {
                change.getDeletePaths().add(path);
                continue;
            }
            if (action.equals("edit") || action.equals("integrate")) {
                change.getModifyPaths().add(path);
                FileUtils.copyFile((File)clientFile, (File)new File(changeStoreDir, path.substring(1)));
                continue;
            }
            Context.getLogger().warn("Unrecognized action: " + action);
        }
        return change;
    }

    @ScriptApi
    public PerforceRepository getRepository() {
        return this.repository;
    }

    private Set<String> getVerifyChangeNumbers() {
        if (this.getChangeNumbers() != null) {
            return new HashSet<String>(StringUtils.splitAndTrim((String)this.getChangeNumbers(), (String)" \t\n,"));
        }
        return new HashSet<String>();
    }
}

