/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.perforce;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.scm.perforce.ClientNameProvider;
import com.pmease.quickbuild.plugin.scm.perforce.PerforceRepository;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import org.springframework.util.StringUtils;

@Editable(name="Auto-generated safe name based on node and root directory", order=100)
public class NodeAndDirBasedClientName
implements ClientNameProvider {
    private static final long serialVersionUID = 1L;
    private PerforceRepository repository;
    private transient String clientName;

    public NodeAndDirBasedClientName(PerforceRepository repository) {
        this.repository = repository;
    }

    @ScriptApi(value="Get associated repository object.")
    public PerforceRepository getRepository() {
        return this.repository;
    }

    @Override
    @ScriptApi(value="Get name of the client.")
    public String getClientName() {
        if (this.clientName == null) {
            GridNode node = ((Grid)Quickbuild.getInstance(Grid.class)).getLocalNode();
            this.clientName = "qb-" + node.getHostName() + "-" + FileUtils.assignIdFor((File)this.repository.getRootDir());
            this.clientName = StringUtils.replace((String)this.clientName, (String)" ", (String)"_");
        }
        return this.clientName;
    }
}

