/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.perforce;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.plugin.scm.perforce.PerforceRepository;
import com.pmease.quickbuild.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class Mapping {
    private boolean exclude;
    private boolean overlay;
    private String depotPath;
    private String clientPath;

    public boolean isExclude() {
        return this.exclude;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public void setOverlay(boolean overlay) {
        this.overlay = overlay;
    }

    public String getDepotPath() {
        return this.depotPath;
    }

    public void setDepotPath(String depotPath) {
        this.depotPath = depotPath;
    }

    public String getClientPath() {
        return this.clientPath;
    }

    public void setClientPath(String clientPath) {
        this.clientPath = clientPath;
    }

    public static List<Mapping> parseView(PerforceRepository repository, String view) {
        Validate.notNull((Object)view);
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        for (String line : StringUtils.split((String)view, (String)"\n")) {
            String[] parts = StringUtils.parseQuoteTokens((String)(line = StringUtils.replace((String)line.trim(), (String)"\t", (String)" ")));
            if (parts.length != 2) {
                throw new QuickbuildException("Invalid mapping line: " + line);
            }
            String depotPath = parts[0].trim();
            if (depotPath.length() == 0) {
                throw new QuickbuildException("Invalid mapping line: " + line);
            }
            Mapping mapping = new Mapping();
            if (depotPath.startsWith("+")) {
                mapping.setOverlay(true);
            } else if (depotPath.startsWith("-")) {
                mapping.setExclude(true);
            }
            depotPath = StringUtils.stripStart((String)depotPath, (String)"+- ");
            if (!depotPath.startsWith("//")) {
                throw new QuickbuildException("Invalid mapping line: " + line);
            }
            mapping.setDepotPath(depotPath);
            String clientPath = parts[1].trim();
            if (clientPath.length() == 0) {
                throw new QuickbuildException("Invalid mapping line: " + line);
            }
            if (!clientPath.startsWith("//")) {
                throw new QuickbuildException("Invalid mapping line: " + line);
            }
            int index = (clientPath = clientPath.substring(2)).indexOf(47);
            if (index == -1) {
                throw new QuickbuildException("Invalid mapping line: " + line);
            }
            mapping.setClientPath("//" + repository.getClientNameProvider().getClientName() + clientPath.substring(index));
            mappings.add(mapping);
        }
        return mappings;
    }
}

