/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.vss;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.scm.vss.VssProofBuildSupport;
import java.io.Serializable;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi(value="Represent a working copy at user's desktop.")
public class WorkingCopy
implements Serializable {
    private VssProofBuildSupport proofBuildSupport;
    private String dir;
    private String project;

    public WorkingCopy(VssProofBuildSupport proofBuildSupport) {
        this.proofBuildSupport = proofBuildSupport;
    }

    @Editable(order=100, name="Directory", description="Specify absolute path to the working copy at users' desktop. QuickBuild will try to get local change recursively from this directory.")
    @NotEmpty
    @ScriptApi(value="Get absolute path to the working copy at user's desktop.")
    @Scriptable
    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    @Editable(order=200, description="Specify corresponding project of the working copy. For example: <b>$/prj/mymodule</b>")
    @NotEmpty
    @ScriptApi(value="Get corresponding project of the working copy.")
    @Scriptable
    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @ScriptApi(value="Get proof build support object.")
    public VssProofBuildSupport getProofBuildSupport() {
        return this.proofBuildSupport;
    }
}

