/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.vss;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.vss.VssRepository;
import com.pmease.quickbuild.plugin.scm.vss.VssRevision;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class VssSourceViewSupport
extends SourceViewSupport<VssRevision> {
    public VssSourceViewSupport(VssRepository repository) {
        super((Repository)repository);
    }

    public VssRepository getRepository() {
        return (VssRepository)super.getRepository();
    }

    public String getRepositoryPath(String checkoutPath) {
        String relativePath;
        try {
            File checkoutFile = new File(Context.getConfiguration().getWorkspaceDir(), checkoutPath);
            relativePath = FileUtils.getRelativePath((String)checkoutFile.getCanonicalPath(), (String)this.getRepository().getDestDir().getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (relativePath == null || relativePath.length() == 0) {
            return null;
        }
        return this.getRepository().getNormalizedProject() + relativePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFile(String repositoryPath, String versionSwitch) {
        Context.getLogger().info("Get file: " + repositoryPath);
        Commandline cmdline = this.getRepository().buildVssCmd().addArgValue("Get").addArgValue(repositoryPath).addArgLine("-I-").addArgValue(versionSwitch).addArgValue("-W");
        this.getRepository().addLogLevelSwitch(cmdline);
        this.getRepository().addAuthenticationSwitches(cmdline, this.getRepository().getVssUser(), this.getRepository().getVssPassword());
        File tempDir = FileUtils.createTempDir((String)"vssreadfile");
        try {
            cmdline.execute(tempDir, this.getRepository().buildVssEnv(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger(), VssRepository.COMMAND_INPUT).checkReturnCode();
            String fileName = StringUtils.substringAfterLast((String)repositoryPath, (String)"/");
            File file = new File(tempDir, fileName);
            if (file.exists() && file.isFile()) {
                List list = FileUtils.readFileAsLines((File)file);
                return list;
            }
            List<String> list = null;
            return list;
        }
        finally {
            FileUtils.deleteDir((File)tempDir);
        }
    }

    public List<String> readSourceByRevision(String repositoryPath, VssRevision revision) {
        if (revision.getLabel() != null) {
            return this.readFile(repositoryPath, "-VL" + revision.getLabel());
        }
        return this.readFile(repositoryPath, "-Vd" + this.getRepository().getDateTimeFormat().format(revision.getDate()) + "~");
    }

    public List<String> readSourceByEdition(String repositoryPath, String edition) {
        return this.readFile(repositoryPath, "-V" + edition);
    }
}

