/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.vss;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.execution.SecretMasker;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.scm.vss.VssPlugin;
import com.pmease.quickbuild.plugin.scm.vss.VssProofBuildSupport;
import com.pmease.quickbuild.plugin.scm.vss.VssRevision;
import com.pmease.quickbuild.plugin.scm.vss.VssSetting;
import com.pmease.quickbuild.plugin.scm.vss.VssSourceViewSupport;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.FlatChange;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.Constants;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import org.apache.tools.ant.types.Environment;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Visual SourceSafe", description="Configure a Visual SourceSafe repository here. By default, QuickBuild expects \"ss.exe\" (Visual SourceSafe command line executable) on the system path. If not, you will need to specify path to this file by configuring the Visual SourceSafe plugin through the plugin management page. There are some limitations of this repository, refer to <a href=\"$docroot/Working+with+Visual+SourceSafe\" target=\"_blank\">the wiki</a> for details.")
@ScriptApi
public class VssRepository
extends Repository<VssRevision> {
    private static final long serialVersionUID = 1L;
    private static final String DATETIME_DECTOR = "datetime-format-detector.exe";
    static final String COMMAND_INPUT = StringUtils.repeat((String)Constants.LINE_SEPARATOR, (int)6);
    private static final int MAX_LOG_ENTRIES = 256;
    private String vssDbPath;
    private String vssUser;
    private String vssPassword;
    private String project;
    private String label;
    private String destPath;
    private String additionalOptions;
    private VssProofBuildSupport proofBuildSupport;

    @Editable(order=100, name="Path to SourceSafe Database", description="Path to the directory where your srcsafe.ini resides in. For example: <b>\\\\vss-machine\\vss-dir</b>.<br><strong>NOTE:</strong> In case of a UNC path, the user account running QuickBuild process needs to login to the remote machine manually if it requires authentication.")
    @NotEmpty
    @ScriptApi(value="Get path to Visual SourceSafe database.")
    @Scriptable
    public String getVssDbPath() {
        return this.vssDbPath;
    }

    public void setVssDbPath(String vssDbPath) {
        this.vssDbPath = vssDbPath;
    }

    @Editable(order=200, name="User Name", description="User name to use to login the above sourcesafe database")
    @NotEmpty
    @ScriptApi(value="Get VSS user to login to the database.")
    @Scriptable
    public String getVssUser() {
        return this.vssUser;
    }

    public void setVssUser(String vssUser) {
        this.vssUser = vssUser;
    }

    @Editable(order=300, name="Password", description="Password for the above user")
    @Password
    @ScriptApi(value="Get VSS password to login to the database.")
    @Scriptable
    public String getVssPassword() {
        return this.vssPassword;
    }

    public void setVssPassword(String vssPassword) {
        this.vssPassword = vssPassword;
    }

    @Editable(order=400, description="Specify the project in the VSS repository, for example: <b>$/testvss</b>.")
    @NotEmpty
    @ScriptApi(value="Get VSS project to checkout.")
    @Scriptable
    public String getProject() {
        return this.project;
    }

    String getNormalizedProject() {
        return VssRepository.normalizeProject(this.getProject());
    }

    static String normalizeProject(String project) {
        return "$/" + StringUtils.stripEnd((String)StringUtils.stripStart((String)project, (String)"$/"), (String)"/");
    }

    public void setProject(String project) {
        this.project = project;
    }

    @Editable(order=500, description="Specify the label for the above project. This property is optional. If left empty, latest version is assumed")
    @ScriptApi(value="Get label to checkout. Null if checkout latest version.")
    @Scriptable
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Editable(order=600, name="Destination Path", description="Specify the directory relative to the workspace directory of current configuration, where the contents under the above source path should be retrieved to. If left empty, retrieved code will be put into the workspace directory.")
    @ScriptApi(value="Get destination path to put checkout files. Null if workspace directory is used as destination path.")
    @Scriptable
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    @Editable(order=650, name="Additional Get Options", description="Specify additional options for the Get command used by QuickBuild to retrieve source code from VSS. Please note that below options will be determined by QuickBuild itself and should not be specified here:<br>-V, -I, -R, -W, -O, -Y")
    public String getAdditionalOptions() {
        return this.additionalOptions;
    }

    public void setAdditionalOptions(String additionalOptions) {
        this.additionalOptions = additionalOptions;
    }

    @Editable(order=700, description="Check this to enable proof build for this repository")
    @ScriptApi(value="Get proof build support object. Null if proof build support is not enabled for this repository.")
    @Advanced
    public VssProofBuildSupport getProofBuildSupport() {
        return this.proofBuildSupport;
    }

    public void setProofBuildSupport(VssProofBuildSupport proofBuildSupport) {
        this.proofBuildSupport = proofBuildSupport;
    }

    @ScriptApi(value="Get revision of this repository.")
    public VssRevision getRevision() {
        return (VssRevision)super.getRevision();
    }

    File getDestDir() {
        if (this.getDestPath() != null) {
            return new File(Context.getConfiguration().getWorkspaceDir(), this.getDestPath());
        }
        return Context.getConfiguration().getWorkspaceDir();
    }

    protected void checkoutByRevision(VssRevision revision) {
        Context.getLogger().info("Get project: " + this.getProject());
        File destDir = this.getDestDir();
        FileUtils.createDir((File)destDir);
        Commandline cmdline = this.buildVssCmd().addArgValue("Get").addArgValue(this.getNormalizedProject());
        if (this.getAdditionalOptions() != null) {
            cmdline.addArgLine(this.getAdditionalOptions());
        }
        cmdline.addArgLine("-I- -R");
        if (revision.getLabel() != null) {
            cmdline.addArgValue("-VL" + revision.getLabel());
        } else {
            cmdline.addArgValue("-Vd" + this.getDateTimeFormat().format(revision.getDate()) + "~");
        }
        cmdline.addArgValue("-W");
        this.addLogLevelSwitch(cmdline);
        this.addAuthenticationSwitches(cmdline, this.getVssUser(), this.getVssPassword());
        cmdline.execute(destDir, this.buildVssEnv(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger(), COMMAND_INPUT).checkReturnCode();
    }

    protected List<Changeset> getChangesBetween(VssRevision startRevision, VssRevision endRevision) {
        if (startRevision.getDate() == null || endRevision.getDate() == null) {
            return new ArrayList<Changeset>();
        }
        Commandline cmdline = this.buildVssCmd().addArgLine("HISTORY -I- -R -#256");
        this.addAuthenticationSwitches(cmdline, this.getVssUser(), this.getVssPassword());
        final SimpleDateFormat dateTimeFormat = this.getDateTimeFormat();
        cmdline.createArgument().setValue("-Vd" + dateTimeFormat.format(endRevision.getDate()) + "~" + dateTimeFormat.format(startRevision.getDate()));
        cmdline.addArgValue(this.getNormalizedProject());
        final ArrayList<FlatChange> flatChanges = new ArrayList<FlatChange>();
        final FlatChange change = new FlatChange();
        cmdline.execute(this.buildVssEnv(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                if (line.startsWith("*****") && line.endsWith("*****")) {
                    if (change.getAction() != null) {
                        flatChanges.add(change.clone());
                    }
                    change.reset();
                    change.setPath(StringUtils.stripEnd((String)StringUtils.stripStart((String)line, (String)"* "), (String)" *"));
                } else if (change.getComment() != null) {
                    if (StringUtils.isNotBlank((String)line)) {
                        change.appendCommentLine(line);
                    }
                } else if (line.startsWith("Version ")) {
                    change.setEdition(line.substring("Version ".length()));
                } else if (line.contains("User:")) {
                    change.setUser(StringUtils.substringBefore((String)StringUtils.substringAfter((String)line, (String)"User: "), (String)"Date:").trim());
                    String datePart = StringUtils.substringAfter((String)line, (String)"Date: ");
                    datePart = StringUtils.substringBefore((String)datePart, (String)"Time:").trim();
                    String timePart = StringUtils.substringAfter((String)line, (String)"Time: ").trim();
                    try {
                        change.setDate(dateTimeFormat.parse(datePart + ";" + timePart));
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                } else if (line.startsWith("Comment: ")) {
                    change.setComment(line.substring("Comment: ".length()));
                } else if (line.startsWith("Checked in ")) {
                    change.setAction(Modification.Action.MODIFY);
                    change.setPath(StringUtils.stripEnd((String)line.substring("Checked in ".length()), (String)"/") + "/" + change.getPath());
                } else if (line.endsWith(" added")) {
                    change.setAction(Modification.Action.ADD);
                    change.setPath("..." + line.substring(0, line.length() - " added".length()));
                } else if (line.endsWith(" destroyed")) {
                    change.setAction(Modification.Action.DELETE);
                    change.setPath("..." + line.substring(0, line.length() - " destroyed".length()));
                } else if (line.endsWith(" deleted")) {
                    change.setAction(Modification.Action.DELETE);
                    change.setPath("..." + line.substring(0, line.length() - " deleted".length()));
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger(), COMMAND_INPUT).checkReturnCode();
        if (change.getAction() != null) {
            flatChanges.add(change);
        }
        return FlatChange.aggregate(flatChanges);
    }

    protected VssRevision getHeadRevision() {
        VssRevision revision = new VssRevision();
        if (this.getLabel() != null) {
            revision.setLabel(this.getLabel());
        } else {
            revision.setDate(new Date());
        }
        return revision;
    }

    protected void labelOnRevision(VssRevision revision, String label, String comment) {
        Context.getLogger().info("Label project: " + this.getProject());
        Commandline cmdline = this.buildVssCmd().addArgValue("Label").addArgValue(this.getNormalizedProject()).addArgValue("-C" + comment).addArgLine("-I-Y -L" + label);
        if (revision.getLabel() != null) {
            cmdline.addArgValue("-VL" + revision.getLabel());
        } else {
            Context.getLogger().warn("Vss can not create label against date. The label will be created against latest code instead.");
        }
        this.addAuthenticationSwitches(cmdline, this.getVssUser(), this.getVssPassword());
        cmdline.execute(this.buildVssEnv(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger(), COMMAND_INPUT).checkReturnCode();
        revision.setLabel(label);
    }

    private VssSetting getVssSetting() {
        return (VssSetting)PluginSettingHelper.getSetting(VssPlugin.class, (boolean)true);
    }

    Commandline buildVssCmd() {
        Commandline cmdline = new Commandline();
        String vssExe = this.getVssSetting().getVssExecutablePath();
        if (vssExe == null) {
            vssExe = "ss";
        }
        cmdline.setExecutable(vssExe);
        return cmdline;
    }

    void addAuthenticationSwitches(Commandline cmdline, final String vssUser, final String vssPassword) {
        if (vssPassword != null) {
            cmdline.addArgValue("-Y" + vssUser + "," + vssPassword);
            cmdline.setSecretMasker(new SecretMasker(){

                public String mask(String message) {
                    return StringUtils.replace((String)message, (String)this.quoteIfNecessary("-Y" + vssUser + "," + vssPassword), (String)this.quoteIfNecessary("-Y" + vssUser + ",******"));
                }
            });
        } else {
            cmdline.createArgument().setValue("-Y" + vssUser);
        }
    }

    void addLogLevelSwitch(Commandline cmdline) {
        if (!Context.getLogger().isInfoEnabled()) {
            cmdline.createArgument().setValue("-O-");
        }
    }

    Environment buildVssEnv() {
        Environment env = new Environment();
        Environment.Variable var = new Environment.Variable();
        var.setKey("SSDIR");
        var.setValue(this.getVssDbPath());
        env.addVariable(var);
        return env;
    }

    SimpleDateFormat getDateTimeFormat() {
        Commandline cmdline = new Commandline();
        cmdline.setExecutable(FileUtils.locateLib(VssRepository.class, (String)DATETIME_DECTOR).getAbsolutePath());
        final ArrayList systemDatetimeFormats = new ArrayList();
        cmdline.execute((OutputStream)new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().debug(line);
                systemDatetimeFormats.add(line);
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        String dateSeperator = (String)systemDatetimeFormats.get(0);
        String dateOrder = (String)systemDatetimeFormats.get(1);
        String timeSeperator = (String)systemDatetimeFormats.get(2);
        String timeAMPM = (String)systemDatetimeFormats.get(3);
        String vssDatetimeFormat = dateOrder.equals("0") ? "M" + dateSeperator + "dd" + dateSeperator + "yy" : (dateOrder.equals("1") ? "d" + dateSeperator + "MM" + dateSeperator + "yy" : "yy" + dateSeperator + "MM" + dateSeperator + "dd");
        vssDatetimeFormat = vssDatetimeFormat + ";";
        vssDatetimeFormat = timeAMPM.equals("0") ? vssDatetimeFormat + "h" + timeSeperator + "mma" : vssDatetimeFormat + "H" + timeSeperator + "mm";
        Context.getLogger().debug("Derived date time format: " + vssDatetimeFormat);
        SimpleDateFormat sdf = new SimpleDateFormat(vssDatetimeFormat);
        DateFormatSymbols dfs = new DateFormatSymbols();
        dfs.setAmPmStrings(new String[]{"a", "p"});
        sdf.setDateFormatSymbols(dfs);
        return sdf;
    }

    public SourceViewSupport<VssRevision> getSourceViewSupport() {
        return new VssSourceViewSupport(this);
    }

    protected boolean isQuietSince(Date date) {
        if (this.getLabel() == null) {
            VssRevision sinceRevision = new VssRevision();
            sinceRevision.setDate(date);
            VssRevision currentRevision = new VssRevision();
            currentRevision.setDate(new Date());
            return this.getChangesBetween(sinceRevision, currentRevision).isEmpty();
        }
        return true;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        Element proofBuildSupportElement = dom.getRootElement().element("proofBuildSupport");
        if (proofBuildSupportElement != null) {
            proofBuildSupportElement.addElement("proofCondition").addAttribute("class", "com.pmease.quickbuild.setting.repository.proofcondition.AlwaysProof");
        }
    }
}

