/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.vss;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.vss.VssLocalChange;
import com.pmease.quickbuild.plugin.scm.vss.VssRepository;
import com.pmease.quickbuild.plugin.scm.vss.WorkingCopy;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi
public class VssProofBuildSupport
extends ProofBuildSupport<VssLocalChange> {
    private VssRepository repository;
    private List<WorkingCopy> workingCopies;
    private String vssUser;
    private String vssPassword;
    private String checkinCondition = "build.successful";
    private String checkinComment;

    @Editable(order=100, description="Specify working copies at user's desktop. Local change will be collected from these working copies and sent to QuickBuild to run proof build.")
    @Size(min=1, message="At least one working copy should be specified")
    @ScriptApi(value="Get working copies at user's destkop from which to collect local change.")
    public List<WorkingCopy> getWorkingCopies() {
        return this.workingCopies;
    }

    public void setWorkingCopies(List<WorkingCopy> workingCopies) {
        this.workingCopies = workingCopies;
    }

    @Editable(order=150, name="User Name", description="Specify Visual SourceSafe user name to be used at user's desktop. If left empty, user name specified at repository level will be used.")
    @ScriptApi(value="Get VSS user name to be used at user's desktop. Null if not specified.")
    @Scriptable
    public String getVssUser() {
        return this.vssUser;
    }

    public void setVssUser(String vssUser) {
        this.vssUser = vssUser;
    }

    @Editable(order=160, name="Password", description="Specify Visual SourceSafe password to be used at user's desktop. If left empty, password specified at repository level will be used.")
    @Password
    @ScriptApi(value="Get password to be used at user's desktop. Null if not specified.")
    @Scriptable
    public String getVssPassword() {
        return this.vssPassword;
    }

    public void setVssPassword(String vssPassword) {
        this.vssPassword = vssPassword;
    }

    @Editable(order=200, description="Specify the condition to checkin local change. If this condition is satisfied, local change in the workspace specified above will be checkin after the build finishes.")
    @Expressions(value={"checkin only when build is successful", "build.successful", "always checkin", "true", "do not checkin", "false"})
    @NotEmpty
    @ScriptApi(value="Get the condition to checkin local change after build finishes.")
    @Scriptable
    public String getCheckinCondition() {
        return this.checkinCondition;
    }

    public void setCheckinCondition(String checkinCondition) {
        this.checkinCondition = checkinCondition;
    }

    @Editable(order=400, description="Specify the comment when checkin the local change. This property only takes effect if the checkin condition specified above is satisfied.")
    @Multiline
    @ScriptApi(value="Get the comment to checkin local change after build finishes.")
    @Scriptable
    public String getCheckinComment() {
        return this.checkinComment;
    }

    public void setCheckinComment(String checkinComment) {
        this.checkinComment = checkinComment;
    }

    public VssProofBuildSupport(VssRepository repository) {
        this.repository = repository;
    }

    public void buildFinished() {
        Boolean isCheckin = (Boolean)((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getCheckinCondition(), Context.buildEvalContext((Object)((Object)this), null));
        if (isCheckin.booleanValue()) {
            Context.getLogger().info("Checkin local change...");
            for (WorkingCopy workingCopy : this.getWorkingCopies()) {
                File workingCopyDir = new File(workingCopy.getDir());
                Commandline cmdline = this.repository.buildVssCmd().addArgValue("CP").addArgValue(workingCopy.getProject());
                this.repository.addAuthenticationSwitches(cmdline, this.getVssUser() != null ? this.getVssUser() : this.repository.getVssUser(), this.getVssPassword() != null ? this.getVssPassword() : this.repository.getVssPassword());
                cmdline.execute(workingCopyDir, this.repository.buildVssEnv(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger(), VssRepository.COMMAND_INPUT).checkReturnCode();
                cmdline = this.repository.buildVssCmd().addArgLine("Checkin * -R");
                if (this.getCheckinComment() != null) {
                    cmdline.addArgValue("-C" + this.getCheckinComment());
                } else {
                    cmdline.addArgValue("-CCheckin by QuickBuild as result of proof build.");
                }
                this.repository.addAuthenticationSwitches(cmdline, this.getVssUser() != null ? this.getVssUser() : this.repository.getVssUser(), this.getVssPassword() != null ? this.getVssPassword() : this.repository.getVssPassword());
                cmdline.execute(workingCopyDir, this.repository.buildVssEnv(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger(), VssRepository.COMMAND_INPUT).checkReturnCode();
            }
        }
    }

    public File getCheckoutFile(String repositoryPath) {
        String relativePath = FileUtils.getRelativePath((String)repositoryPath.substring(1), (String)StringUtils.stripStart((String)this.repository.getProject(), (String)"$"));
        if (relativePath != null) {
            return new File(this.repository.getDestDir(), relativePath);
        }
        return null;
    }

    public VssLocalChange getLocalChange(File changeStoreDir) {
        final VssLocalChange change = new VssLocalChange();
        for (WorkingCopy workingCopy : this.getWorkingCopies()) {
            File workingCopyDir = new File(workingCopy.getDir());
            Commandline cmdline = this.repository.buildVssCmd().addArgLine("diff -R").addArgValue(VssRepository.normalizeProject(workingCopy.getProject()));
            final String[] projectReposPath = new String[]{null};
            final File[] projectDir = new File[]{null};
            final Modification.Action[] action = new Modification.Action[]{null};
            final Boolean[] diffRun = new Boolean[]{false};
            final HashMap addedFiles = new HashMap();
            final HashMap modifiedFiles = new HashMap();
            cmdline.execute(workingCopyDir, this.repository.buildVssEnv(), (OutputStream)new LineConsumer(){

                public void consume(String line) {
                    Context.getLogger().debug(line);
                    if (line.startsWith("Diffing: ")) {
                        projectReposPath[0] = StringUtils.stripEnd((String)line.substring("Diffing: ".length()), (String)"/");
                        action[0] = null;
                        diffRun[0] = true;
                    } else if (line.startsWith("Against: ")) {
                        projectDir[0] = new File(line.substring("Against: ".length()));
                    } else if (line.startsWith("Local files not in the current project:")) {
                        action[0] = Modification.Action.ADD;
                    } else if (line.startsWith("SourceSafe files not in the current folder:")) {
                        action[0] = Modification.Action.DELETE;
                    } else if (line.startsWith("SourceSafe files different from local files:")) {
                        action[0] = Modification.Action.MODIFY;
                    } else if (action[0] != null && line.trim().length() != 0) {
                        for (String fileName : StringUtils.split((String)line, (String)" ")) {
                            String fileReposPath = projectReposPath[0] + "/" + fileName;
                            if (action[0] == Modification.Action.DELETE) {
                                change.getDeletePaths().add(fileReposPath);
                                continue;
                            }
                            if (action[0] == Modification.Action.ADD) {
                                addedFiles.put(fileReposPath, new File(projectDir[0], fileName));
                                continue;
                            }
                            modifiedFiles.put(fileReposPath, new File(projectDir[0], fileName));
                        }
                    }
                }
            }, (LineConsumer)new LineConsumer.WarnLogger(), VssRepository.COMMAND_INPUT);
            if (!diffRun[0].booleanValue()) {
                throw new QuickbuildException("Failed to run diff command");
            }
            for (Map.Entry entry : addedFiles.entrySet()) {
                change.getAddPaths().add(entry.getKey());
                FileUtils.copyFile((File)((File)entry.getValue()), (File)new File(changeStoreDir, ((String)entry.getKey()).substring(1)));
            }
            for (Map.Entry entry : modifiedFiles.entrySet()) {
                change.getModifyPaths().add(entry.getKey());
                FileUtils.copyFile((File)((File)entry.getValue()), (File)new File(changeStoreDir, ((String)entry.getKey()).substring(1)));
            }
        }
        return change;
    }

    @ScriptApi(value="Get repository object.")
    public VssRepository getRepository() {
        return this.repository;
    }
}

