/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.pmd.renderer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.ViewSourceLinkItem;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.pmd.renderer.ViolationBlock;
import com.pmease.quickbuild.web.page.source.Block;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.util.ArrayList;
import java.util.List;

public class ViewViolationSourceItem
extends ViewSourceLinkItem {
    private static final long serialVersionUID = 1L;

    public ViewViolationSourceItem(AbstractRenderer renderer) {
        super(renderer);
        this.setImageUrl("report/viewsource.gif");
        this.setTextExpression("View source");
        this.setTooltip("View source code of the violations");
    }

    protected SourceViewPage createSourceViewPage(String title, String sourceType, String[] lines, Block[] blocks, int startLine) {
        return new SourceViewPage(title, sourceType, lines, blocks, startLine){
            private static final long serialVersionUID = 1L;

            protected String renderContent(String[] lines, Block[] blocks) {
                StringBuffer sb = new StringBuffer();
                int i = 1;
                sb.append("<table>");
                if (blocks.length > 0) {
                    for (Block each : blocks) {
                        while (i < each.getStartLine() && i < lines.length) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits'></td>");
                            sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                        String color = each.getColor();
                        String message = 1.escapeMessage((String)each.getMessage());
                        while (i <= each.getEndLine() && i < lines.length) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits' style='background-color: ").append(color).append("'>").append("<div class='with-msg' ").append("title=\"").append(message).append("\">");
                            if (i == each.getStartLine()) {
                                sb.append(((ViolationBlock)each).getAbbrev());
                            } else {
                                sb.append("&nbsp;&nbsp;&nbsp;");
                            }
                            sb.append("</div>").append("</td>");
                            sb.append("<td class='line-content' style='border-color: ").append(color).append("'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                    }
                }
                while (i <= lines.length) {
                    sb.append("<tr>");
                    sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                    if (blocks.length > 0) {
                        sb.append("<td class='hits'></td>");
                    }
                    sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                    sb.append("</tr>");
                    ++i;
                }
                sb.append("</table>");
                return sb.toString();
            }
        };
    }

    protected Block[] rowsToBlocks(List<DataRow> rows) {
        ArrayList blocks = Lists.newArrayList();
        for (DataRow each : rows) {
            ViolationBlock.DiffStatus diffStatus = ViolationBlock.DiffStatus.valueOf(each.getValueAsString("diffStatus"));
            ViolationBlock block = new ViolationBlock();
            block.setStartLine(each.getInt("beginLine"));
            block.setEndLine(each.getInt("endLine"));
            block.priority = ViolationBlock.Priority.valueOf(each.getValueAsString("priority"));
            block.diffStatus = diffStatus;
            block.setMessage(each.getValueAsString("rule") + ": " + each.getValueAsString("message"));
            block.setColor(ViewViolationSourceItem.getColor(block));
            blocks.add(block);
        }
        if (rows.size() > 0 && blocks.isEmpty()) {
            ViolationBlock block = new ViolationBlock();
            block.setStartLine(1);
            block.setEndLine(1);
            block.setColor("#008C00");
            block.setMessage("All violations were fixed.");
            blocks.add(block);
        }
        return (Block[])Iterables.toArray((Iterable)blocks, Block.class);
    }

    static String getColor(ViolationBlock block) {
        if (block.getDiffStatus() == ViolationBlock.DiffStatus.FIXED) {
            return "#008C00";
        }
        return ReportUtils.getPriorityColor((String)block.priority.name());
    }
}

