/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.pmd.generator;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractDataReportProcessor;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.dom4j.Element;

public class InstanceIdProcessor
extends AbstractDataReportProcessor {
    private static final long serialVersionUID = 1L;

    public InstanceIdProcessor(ReportCategory category) {
        super(category);
    }

    public String getType() {
        return "PMD-InstanceId";
    }

    protected AbstractRule createDefaultRule() {
        return null;
    }

    protected void processResource(GeneratorResource resource) {
        GeneratorContext context = this.getContext();
        DataReport destReport = context.getDestReport();
        Build build = Context.getBuild();
        File workspaceDir = build.getConfiguration().getWorkspaceDir();
        File previousFile = null;
        List lines = Lists.newArrayList();
        for (DataRow src : destReport.getRows()) {
            String fileName = src.getValueAsString("fileName");
            File file = new File(fileName);
            if (!file.isAbsolute()) {
                file = new File(build.getConfiguration().getWorkspaceDir(), fileName);
            }
            String relativePath = fileName;
            if (file.exists()) {
                boolean loadSource;
                relativePath = ReportUtils.getRelativePath((String)file.getAbsolutePath(), (String)workspaceDir.getAbsolutePath());
                src.setValue("fileName", (Object)relativePath);
                boolean bl = loadSource = !Objects.equal(previousFile, (Object)file) || lines.isEmpty();
                if (loadSource) {
                    try {
                        lines = FileUtils.readFileAsLines((File)file);
                        previousFile = file;
                    }
                    catch (Exception e) {
                        Throwable t = ExceptionUtils.extractException((Throwable)e, IOException.class);
                        if (t != null) continue;
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }
            int beginLine = src.getInt("beginLine");
            int endLine = src.getInt("endLine");
            StringBuffer sb = new StringBuffer();
            sb.append(relativePath).append(":").append(src.getString("rule")).append(":").append(src.getString("ruleset"));
            if (lines.isEmpty()) {
                sb.append(beginLine).append(":").append(endLine);
            } else {
                int start = Math.max(0, beginLine - 1);
                int end = Math.max(1, Math.min(endLine, lines.size()));
                sb.append(Joiner.on((char)'\n').join(lines.subList(start, end)));
            }
            String instanceId = DigestUtils.md5Hex((String)sb.toString());
            src.setValue("instanceId", (Object)instanceId);
        }
        context.setDestReport(destReport);
    }

    public void fromXML(Element node) {
    }
}

