/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.pmd;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.pmd.PMDPlugin;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections.MapUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, name="PMD Report", description="<strong>Notice</strong><br/>Make sure this step is running on the same node as the node where you run pmd (normally, this will be the node your builder running)")
@ScriptApi(value="This step publishes the original PMD XML files.")
public class PMDPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private int violations;
    @XStreamOmitField
    private int highs;
    @XStreamOmitField
    private int mediums;
    @XStreamOmitField
    private int normals;
    @XStreamOmitField
    private int lows;

    public PMDPublisher() {
        this.setStepFailureCondition("false");
        this.setStepFailureMessage("");
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(PMDPlugin.class);
    }

    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        ReportCategory category = this.getCategory();
        File dbDir = context.getWorkingDir();
        if (!dbDir.exists()) {
            return;
        }
        DataReport statsReport = category.createReport("stats");
        Map stats = category.getDefaultStats(dbDir, "packages", new Filter[0]);
        DataRow row = statsReport.addRow();
        row.fromMap(stats);
        row.setValue("buildId", (Object)context.getCurrentBuild().getId());
        row.setValue("packages", (Object)MapUtils.getLong((Map)stats, (Object)"TOTALS", (Long)0L));
        this.violations = row.getInt("violations");
        this.highs = row.getInt("highs");
        this.mediums = row.getInt("mediums");
        this.normals = row.getInt("normals");
        this.lows = row.getInt("lows");
        category.saveReport(dbDir, statsReport);
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return ImmutableMap.builder().put((Object)"byViolationsUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"by_violation", (String)reportsetName)).build();
    }

    protected String getStatsReportName() {
        return "stats";
    }

    public boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @Editable(order=1000, description="The step failure condition is to determin whether this step will be failed or not. If the evaluated result is <strong>true</strong>, QuickBuild will fail this step and also set the whole build status to fail, otherwise, the step will be successful.")
    @Expressions(value={"I don't care", "false"})
    @NotEmpty
    @Multiline
    @ScriptApi(value="Get step failure condition. A <strong>Boolean</strong> type expression string.")
    @Scriptable
    public String getStepFailureCondition() {
        return super.getStepFailureCondition();
    }

    @Editable(order=1100, description="The step failure message is to display a failure message in build dashboard and build log when step failure condition is matched.")
    @Multiline
    @ScriptApi(value="Get step failure message. If the failure message is not set, the default message will be used.")
    @Scriptable
    @Advanced
    public String getStepFailureMessage() {
        return super.getStepFailureMessage();
    }

    @ScriptApi(value="Total violations in PMD report.")
    public int getViolations() {
        return this.violations;
    }

    public void setViolations(int violations) {
        this.violations = violations;
    }

    @ScriptApi(value="Total high priority violations in PMD report.")
    public int getHighs() {
        return this.highs;
    }

    public void setHighs(int highs) {
        this.highs = highs;
    }

    @ScriptApi(value="Total medium priority violations in PMD report.")
    public int getMediums() {
        return this.mediums;
    }

    public void setMediums(int mediums) {
        this.mediums = mediums;
    }

    @ScriptApi(value="Total normal priority violations in PMD report.")
    public int getNormals() {
        return this.normals;
    }

    public void setNormals(int normals) {
        this.normals = normals;
    }

    @ScriptApi(value="Total low priority violations in PMD report.")
    public int getLows() {
        return this.lows;
    }

    public void setLows(int lows) {
        this.lows = lows;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.setValue("stepFailureCondition", "false");
        dom.setValue("stepFailureMessage", "");
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        PMDPublisher.removeElement((VersionedDocument)dom, (String)"violations");
        PMDPublisher.removeElement((VersionedDocument)dom, (String)"highs");
        PMDPublisher.removeElement((VersionedDocument)dom, (String)"mediums");
        PMDPublisher.removeElement((VersionedDocument)dom, (String)"normals");
        PMDPublisher.removeElement((VersionedDocument)dom, (String)"lows");
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return PMDChecksum.class;
    }

    public static class PMDChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(PMDPlugin.class);
        }
    }
}

