/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.testng.renderer;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.testng.DiffStatus;
import com.pmease.quickbuild.plugin.report.testng.TestStatus;
import com.pmease.quickbuild.plugin.report.testng.renderer.MethodDetailsColumn;
import java.io.Serializable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class MethodDetailsColumnPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public MethodDetailsColumnPanel(String id, MethodDetailsColumn column, IModel<ItemContext> model) {
        super(id);
        ItemContext context = (ItemContext)model.getObject();
        DataRow row = context.getDataRow();
        WebMarkupContainer anchor = new WebMarkupContainer("anchor");
        anchor.add(new Behavior[]{new AttributeModifier("name", (IModel)Model.of((Serializable)row.getId()))});
        String methodName = row.getString("methodName") + "(" + row.getValueAsString("params") + ")";
        anchor.add(new Component[]{new Label("method", methodName)});
        this.add(new Component[]{anchor});
        TestStatus status = TestStatus.valueOf(row.getValueAsString("status"));
        DiffStatus diffStatus = DiffStatus.valueOf(row.getValueAsString("diffStatus"));
        this.add(new Component[]{new Label("status", status.name()).add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)status.name().toLowerCase())), " ")})});
        int runs = row.getInt("runs");
        WebMarkupContainer runsContainer = new WebMarkupContainer("runsContainer");
        if (runs > 1) {
            runsContainer.add(new Component[]{new Label("passedRuns", row.getString("passedRuns"))});
            runsContainer.add(new Component[]{new Label("failedRuns", row.getString("failedRuns"))});
            runsContainer.add(new Component[]{new Label("skippedRuns", row.getString("skippedRuns"))});
        } else {
            runsContainer.setVisible(false);
        }
        this.add(new Component[]{runsContainer});
        String committers = row.getValueAsString("committers");
        this.add(new Component[]{new Label("committers", committers).setVisible(!Strings.isNullOrEmpty((String)committers) && diffStatus != DiffStatus.UNCHANGED && diffStatus != DiffStatus.NOT_FIXED)});
        this.add(new Component[]{new Label("diffStatus", diffStatus.name())});
        this.add(new Component[]{column.testLinkItem.createComponent("testLink", model)});
        this.add(new Component[]{column.suiteLinkItem.createComponent("suiteLink", model)});
        this.add(new Component[]{column.packageLinkItem.createComponent("packageLink", model)});
        this.add(new Component[]{column.classLinkItem.createComponent("classLink", model)});
        String str = row.getValueAsString("dependsOnMethods");
        this.add(new Component[]{new Label("dependsMethods", str).setEscapeModelStrings(true).setVisible(!Strings.isNullOrEmpty((String)str))});
        str = row.getValueAsString("dependsOnGroups");
        this.add(new Component[]{new Label("dependsGroups", str).setEscapeModelStrings(true).setVisible(!Strings.isNullOrEmpty((String)str))});
        str = row.getValueAsString("exceptionClass");
        this.add(new Component[]{new Label("exceptionClass", str).setEscapeModelStrings(true).setVisible(!Strings.isNullOrEmpty((String)str))});
        str = row.getValueAsString("exceptionMessage").trim();
        this.add(new Component[]{new Label("exceptionMessage", ReportUtils.wrapAsHtmlMultiline((String)str, (int)0)).setEscapeModelStrings(false).setVisible(!Strings.isNullOrEmpty((String)str))});
        str = row.getValueAsString("shortStack").trim();
        this.add(new Component[]{new Label("shortStack", "<pre>" + StringEscapeUtils.escapeHtml((String)str) + "</pre>").setEscapeModelStrings(false).setVisible(!Strings.isNullOrEmpty((String)str))});
        str = row.getValueAsString("fullStack").trim();
        this.add(new Component[]{new Label("fullStack", "<pre>" + StringEscapeUtils.escapeHtml((String)str) + "</pre>").setEscapeModelStrings(false).setVisible(!Strings.isNullOrEmpty((String)str))});
    }
}

