/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.testng.migration;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.ReportCategoryMigrator;
import java.io.File;
import java.util.Map;
import java.util.Stack;

public class TestNGMigrator
extends ReportCategoryMigrator {
    private void migrate1(MigrationContext context, Stack<Integer> versions) {
        this.migrateFromXMLToH2(context);
    }

    protected void report3To4(ReportMetaData meta, MigrationContext context, CategoryDb db) {
        if (!"tests_trends".equalsIgnoreCase(meta.getReportName())) {
            if ("methods".equalsIgnoreCase(meta.getReportName())) {
                DataReport report = new DataReport(meta);
                File file = new File(db.getDbDir(), report.getOutputName());
                if (!file.exists()) {
                    return;
                }
                report.loadFromXML(file);
                for (DataRow each : report.getRows()) {
                    String status = each.getString("status");
                    if ("ERROR".equalsIgnoreCase(status)) {
                        status = "FAIL";
                        each.setValue("status", (Object)"FAIL");
                    }
                    each.setValue("runs", (Object)1);
                    if ("PASS".equalsIgnoreCase(status)) {
                        each.setValue("passedRuns", (Object)1);
                        continue;
                    }
                    if ("FAIL".equalsIgnoreCase(status)) {
                        each.setValue("failedRuns", (Object)1);
                        continue;
                    }
                    each.setValue("skippedRuns", (Object)1);
                }
                db.saveReport(report);
            } else {
                super.report3To4(meta, context, db);
            }
        }
    }

    protected void buildStats3To4(MigrationContext context, CategoryDb db) {
        ReportCategory category = db.getCategory();
        DataReport statsReport = category.createReport("stats");
        DataRow row = statsReport.addRow();
        Map stats = category.getDefaultStats(db, "suites", new Filter[0]);
        row.fromMap(stats);
        int methods = row.getInt("methods");
        int errors = row.getInt("errors");
        double success_rate = methods == 0 ? 0.0 : (double)(methods - errors) / new Double(methods);
        row.setValue("success_rate", (Object)success_rate);
        row.setValue("buildId", (Object)context.getBuild().getId());
        category.saveReport(db, statsReport);
    }
}

