/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.testng.aggregation;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.aggregation.ReportAggregator;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.testng.TestNGPlugin;

@Editable(name="TestNG Report")
public class TestNGAggregator
extends ReportAggregator {
    private static final long serialVersionUID = 1L;

    public ReportCategory getCategory() {
        return ReportHelper.getCategory(TestNGPlugin.class);
    }

    static void setSuccessRate(DataRow destRow) {
        int tests = destRow.getInt("methods");
        int errors = destRow.getInt("errors");
        double success_rate = MathUtils.divide((int)(tests - errors), (int)tests);
        destRow.setValue("success_rate", (Object)success_rate);
    }

    protected void aggregateOverview(DataRow sourceRow, DataRow destRow) {
        super.aggregateOverview(sourceRow, destRow);
        TestNGAggregator.setSuccessRate(destRow);
    }

    protected void updateStatsRow(DataRow destRow) {
        super.updateStatsRow(destRow);
        TestNGAggregator.setSuccessRate(destRow);
    }
}

