/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.testng;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.testng.TestNGPlugin;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import java.util.Stack;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, name="TestNG Report", description="Publish TestNG reports")
@ScriptApi(value="This step publishes the original TestNG XML files.")
public class TestNGPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private int methods;
    @XStreamOmitField
    private int errors;
    @XStreamOmitField
    private int skips;

    public TestNGPublisher() {
        this.setStepFailureCondition("current.errors > 0");
        this.setStepFailureMessage("Found failed tests in TestNG report.");
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(TestNGPlugin.class);
    }

    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        ReportCategory category = this.getCategory();
        File dbDir = context.getWorkingDir();
        if (!dbDir.exists()) {
            return;
        }
        DataReport statsReport = category.createReport("stats");
        Map stats = category.getDefaultStats(dbDir, "suites", new Filter[0]);
        DataRow row = statsReport.addRow();
        row.fromMap(stats);
        row.setValue("buildId", (Object)context.getCurrentBuild().getId());
        this.methods = row.getInt("methods");
        this.errors = row.getInt("errors");
        this.skips = row.getInt("skips");
        row.setValue("success_rate", (Object)(this.methods == 0 ? 0.0 : new Double(this.methods - this.errors) / (double)this.methods));
        category.saveReport(dbDir, statsReport);
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return ImmutableMap.builder().put((Object)"byMethodsUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"by_method", (String)reportsetName)).put((Object)"failedMethodsUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"failed_tests", (String)reportsetName)).build();
    }

    protected String getStatsReportName() {
        return "stats";
    }

    public boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @Editable(order=1000, description="The step failure condition is to determin whether this step will be failed or not. If the evaluated result is <strong>true</strong>, QuickBuild will fail this step and also set the whole build status to fail, otherwise, the step will be successful.")
    @Expressions(value={"has failed tests", "current.errors > 0", "I don't care", "false"})
    @NotEmpty
    @Multiline
    @ScriptApi(value="Get step failure condition. A <strong>Boolean</strong> type expression string.")
    @Scriptable
    public String getStepFailureCondition() {
        return super.getStepFailureCondition();
    }

    @ScriptApi(value="Total methods in TestNG report.")
    public int getMethods() {
        return this.methods;
    }

    public void setMethods(int methods) {
        this.methods = methods;
    }

    @ScriptApi(value="Total errors in TestNG report.")
    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    @ScriptApi(value="Total skipped runs in TestNG report.")
    public int getSkips() {
        return this.skips;
    }

    public void setSkips(int skips) {
        this.skips = skips;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.setValue("stepFailureCondition", "current.errors > 0");
        dom.setValue("stepFailureMessage", "Found failed tests in TestNG report.");
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        TestNGPublisher.removeElement((VersionedDocument)dom, (String)"duration");
        TestNGPublisher.removeElement((VersionedDocument)dom, (String)"methods");
        TestNGPublisher.removeElement((VersionedDocument)dom, (String)"errors");
        TestNGPublisher.removeElement((VersionedDocument)dom, (String)"skips");
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return TestNGChecksum.class;
    }

    public static class TestNGChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(TestNGPlugin.class);
        }
    }
}

