/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.testng;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.testng.TestStatus;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.util.EqualsHelper;

public class TestLatestMetricRule
extends ExpressionRule {
    private static final long serialVersionUID = 1L;
    private static final String[] columns = new String[]{"runs", "failures", "skips", "lastRunBuild", "latestBuilds", "latestStatuses", "latestDuration", "currentStatus", "averageDuration"};

    public TestLatestMetricRule(ReportCategory category) {
        super(category);
    }

    public String getType() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void doExecute() {
        String currentStatus;
        GeneratorContext context = this.getContext();
        DataRow destRow = context.getDestRow();
        DataRow sourceRow = context.getSourceRow();
        List latestBuilds = (List)destRow.getValue("latestBuilds");
        List latestStatuses = (List)destRow.getValue("latestStatuses");
        List latestDurations = (List)destRow.getValue("latestDurations");
        Long buildId = context.getCurrentBuild().getId();
        int index = -1;
        for (int i = 0; i < latestBuilds.size(); ++i) {
            Long b = (Long)latestBuilds.get(i);
            if (!EqualsHelper.equals((Object)buildId, (Object)b)) continue;
            index = i;
            break;
        }
        String status = sourceRow.getValueAsString("status");
        Long duration = (Long)sourceRow.getValue("duration");
        if (index == -1) {
            latestBuilds = ReportUtils.limitAddingValue((List)latestBuilds, (Object)buildId);
            latestStatuses = ReportUtils.limitAddingValue((List)latestStatuses, (Object)status);
            latestDurations = ReportUtils.limitAddingValue((List)latestDurations, (Object)duration);
            currentStatus = status;
        } else {
            String destStatus = (String)latestStatuses.get(index);
            Long destDuration = (Long)latestDurations.get(index);
            currentStatus = TestLatestMetricRule.evaluateStatus(destStatus, status);
            latestStatuses.set(index, currentStatus);
            latestDurations.set(index, destDuration + duration);
        }
        destRow.setValue("runs", (Object)(destRow.getInt("runs") + sourceRow.getInt("runs")));
        destRow.setValue("failures", (Object)(destRow.getInt("failures") + sourceRow.getInt("failedRuns")));
        destRow.setValue("skips", (Object)(destRow.getInt("skips") + sourceRow.getInt("skippedRuns")));
        destRow.setValue("lastRunBuild", (Object)context.getCurrentBuild().getId());
        destRow.setValue("latestBuilds", (Object)latestBuilds);
        destRow.setValue("latestStatuses", (Object)latestStatuses);
        destRow.setValue("latestDurations", (Object)latestDurations);
        destRow.setValue("currentStatus", (Object)currentStatus);
        destRow.setValue("averageDuration", (Object)ReportUtils.average(new ArrayList(latestDurations)));
    }

    static String evaluateStatus(String current, String source) {
        TestStatus sCurrent = TestStatus.SKIP;
        TestStatus sSource = TestStatus.SKIP;
        if (!StringUtils.isEmpty((String)current)) {
            sCurrent = TestStatus.valueOf(current.toUpperCase());
        }
        if (!StringUtils.isEmpty((String)source)) {
            sSource = TestStatus.valueOf(source.toUpperCase());
        }
        if (sSource.ordinal() - sCurrent.ordinal() > 0) {
            return source;
        }
        return current;
    }

    protected String[] forColumns() {
        return columns;
    }
}

