/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.testng;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.plugin.report.testng.TestStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class MethodProcessor
extends XPathProcessor {
    private static final long serialVersionUID = 1L;

    public MethodProcessor(ReportCategory category) {
        super(category);
    }

    protected void processResource(GeneratorResource resource) {
        GeneratorContext context = GeneratorContext.getContext();
        File file = resource.getFile();
        DataReport destReport = context.getDestReport();
        Document doc = XMLHelper.readXML((File)file);
        List nodes = doc.selectNodes("//test-method");
        Map rowMap = destReport.getRowIndexMap();
        Build build = context.getCurrentBuild();
        for (Element each : nodes) {
            String className = each.valueOf("../@name");
            String packageName = ReportUtils.getPackageNameFromClassName((String)className);
            className = ReportUtils.getClassNameFromClassName((String)className);
            String signature = each.valueOf("./@signature");
            String methodName = each.valueOf("./@name");
            String test = each.valueOf("../../@name");
            String suite = each.valueOf("../../../@name");
            List paramNodes = each.selectNodes("./params/param");
            ArrayList params = Lists.newArrayList();
            for (Element paramNode : paramNodes) {
                params.add(paramNode.valueOf("normalize-space(./value)"));
            }
            DataRow row = new DataRow(destReport);
            row.setValue("signature", (Object)signature);
            row.setValue("suiteName", (Object)suite);
            row.setValue("testName", (Object)test);
            row.setValue("packageName", (Object)packageName);
            row.setValue("className", (Object)className);
            row.setValue("methodName", (Object)methodName);
            row.setValue("params", (Object)params);
            row.setValue("dependsOnMethods", (Object)Lists.newArrayList((Object[])new String[]{each.valueOf("./@depends-on-methods")}));
            row.setValue("dependsOnGroups", (Object)Lists.newArrayList((Object[])new String[]{each.valueOf("./@depends-on-groups")}));
            row.setValue("duration", (Object)each.numberValueOf("./@duration-ms"));
            row.setValue("exceptionClass", (Object)each.valueOf("./exception/@class"));
            row.setValue("exceptionMessage", (Object)each.valueOf("./exception/message"));
            row.setValue("fullStack", (Object)each.valueOf("./exception/full-stacktrace"));
            row.setValue("shortStack", (Object)each.valueOf("./exception/short-stacktrace"));
            TestStatus status = TestStatus.valueOf(each.valueOf("./@status"));
            if (status == TestStatus.SUCCESS_PERCENTAGE_FAILURE) {
                status = TestStatus.FAIL;
            }
            row.setValue("status", (Object)status.name());
            row.setValue("runs", (Object)1);
            if (status == TestStatus.PASS) {
                row.setValue("passedRuns", (Object)1);
            } else if (status == TestStatus.FAIL) {
                row.setValue("failedRuns", (Object)1);
            } else if (status == TestStatus.SKIP) {
                row.setValue("skippedRuns", (Object)1);
            }
            String key = row.getRowKeyString();
            Integer existIndex = (Integer)rowMap.get(key);
            if (existIndex != null) {
                row = this.mergeRow(row, (DataRow)destReport.getRows().get(existIndex));
            } else {
                row = destReport.addRow(row);
                rowMap.put(key, destReport.getRowsCount() - 1);
            }
            List committers = ReportUtils.findCommittersByClassName((Build)build, (String)packageName, (String)className);
            row.setValue("committers", (Object)committers);
        }
    }

    private DataRow mergeRow(DataRow row, DataRow exist) {
        List newValue = (List)row.getValue("dependsOnMethods");
        List oldValue = (List)exist.getValue("dependsOnMethods");
        for (String each : newValue) {
            if (oldValue.contains(each)) continue;
            oldValue.add(each);
        }
        exist.setValue("dependsOnMethods", (Object)oldValue);
        newValue = (List)row.getValue("dependsOnGroups");
        oldValue = (List)exist.getValue("dependsOnGroups");
        for (String each : newValue) {
            if (oldValue.contains(each)) continue;
            oldValue.add(each);
        }
        exist.setValue("dependsOnGroups", (Object)oldValue);
        long newDuration = row.getLong("duration");
        long oldDuration = exist.getLong("duration");
        exist.setValue("duration", (Object)(newDuration + oldDuration));
        exist.setValue("runs", (Object)(row.getInt("runs") + exist.getInt("runs")));
        exist.setValue("passedRuns", (Object)(row.getInt("passedRuns") + exist.getInt("passedRuns")));
        exist.setValue("failedRuns", (Object)(row.getInt("failedRuns") + exist.getInt("failedRuns")));
        exist.setValue("skippedRuns", (Object)(row.getInt("skippedRuns") + exist.getInt("skippedRuns")));
        TestStatus newStatus = TestStatus.valueOf(row.getString("status"));
        TestStatus oldStatus = TestStatus.valueOf(exist.getString("status"));
        newStatus = oldStatus == TestStatus.FAIL || newStatus == TestStatus.FAIL ? TestStatus.FAIL : (oldStatus == TestStatus.SKIP && newStatus == TestStatus.SKIP ? TestStatus.SKIP : TestStatus.PASS);
        exist.setValue("status", (Object)newStatus.name());
        MethodProcessor.newValueIfAvailable(exist, row, "exceptionClass");
        MethodProcessor.newValueIfAvailable(exist, row, "exceptionMessage");
        MethodProcessor.newValueIfAvailable(exist, row, "shortStack");
        MethodProcessor.newValueIfAvailable(exist, row, "fullStack");
        return exist;
    }

    static void newValueIfAvailable(DataRow current, DataRow newRow, String columnName) {
        String newValue = newRow.getString(columnName);
        if (!Strings.isNullOrEmpty((String)newValue)) {
            current.setValue(columnName, (Object)newValue);
        }
    }
}

