/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.nunit.renderer;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.nunit.renderer.TestDetailsColumn;
import java.io.Serializable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TestDetailsColumnPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public TestDetailsColumnPanel(String id, TestDetailsColumn column, IModel<ItemContext> model) {
        super(id, model);
        ItemContext context = (ItemContext)model.getObject();
        DataRow row = context.getDataRow();
        WebMarkupContainer anchor = new WebMarkupContainer("anchor");
        anchor.add(new Behavior[]{new AttributeModifier("name", (IModel)Model.of((Serializable)row.getId()))});
        anchor.add(new Component[]{new Label("testName", row.getValueAsString("testName"))});
        this.add(new Component[]{anchor});
        this.add(new Component[]{new Label("diffStatus", row.getValueAsString("diffStatus"))});
        String status = row.getValueAsString("status");
        Label statusLabel = new Label("status", status);
        statusLabel.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)status.toLowerCase())), " ")});
        this.add(new Component[]{statusLabel});
        this.add(new Component[]{column.namespaceLinkItem.createComponent("namespaceLink", model)});
        this.add(new Component[]{column.testsuiteLinkItem.createComponent("testsuiteLink", model)});
        String description = row.getValueAsString("description");
        this.add(new Component[]{new Label("description", StringEscapeUtils.escapeHtml((String)description)).setEscapeModelStrings(true).setVisible(!Strings.isNullOrEmpty((String)description))});
        this.add(new Component[]{new Label("asserts", row.getValueAsString("asserts"))});
        this.add(new Component[]{new Label("duration", row.getValueAsString("duration")).setEscapeModelStrings(true)});
        this.add(new Component[]{new Label("message", ReportUtils.wrapAsHtmlMultiline((String)row.getValueAsString("message"), (int)0)).setEscapeModelStrings(false).setVisible(!Strings.isNullOrEmpty((String)row.getValueAsString("message")))});
        this.add(new Component[]{new Label("stacktrace", ReportUtils.wrapAsHtmlMultiline((String)row.getValueAsString("exceptionStack"), (int)0)).setEscapeModelStrings(false).setVisible(!Strings.isNullOrEmpty((String)row.getValueAsString("exceptionStack")))});
    }
}

