/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.nunit.migration;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.ReportCategoryMigrator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class NUnitMigrator
extends ReportCategoryMigrator {
    private void migrate1(MigrationContext context, Stack<Integer> versions) {
        this.migrateFromXMLToH2(context);
    }

    protected void report3To4(ReportMetaData meta, MigrationContext context, CategoryDb db) {
        if ("tests".equalsIgnoreCase(meta.getReportName())) {
            DataReport report = new DataReport(meta);
            File file = new File(db.getDbDir(), report.getOutputName());
            if (!file.exists()) {
                return;
            }
            report.loadFromXML(file);
            for (DataRow each : report.getRows()) {
                String status = each.getString("status");
                if (!"ERROR".equalsIgnoreCase(status)) continue;
                each.setValue("status", (Object)"FAIL");
            }
            db.saveReport(report);
        } else if ("tests_trends".equalsIgnoreCase(meta.getReportName())) {
            DataReport report = new DataReport(meta);
            File file = new File(db.getDbDir(), report.getOutputName());
            if (!file.exists()) {
                return;
            }
            report.loadFromXML(file);
            for (DataRow each : report.getRows()) {
                List latestStatuses = (List)each.getValue("latestStatuses");
                ArrayList list = Lists.newArrayList();
                for (String str : latestStatuses) {
                    if ("ERROR".equalsIgnoreCase(str)) {
                        list.add("FAIL");
                        continue;
                    }
                    list.add(str);
                }
                each.setValue("latestStatuses", (Object)list);
            }
            db.saveReport(report);
        } else {
            super.report3To4(meta, context, db);
        }
    }

    protected void buildStats3To4(MigrationContext context, CategoryDb db) {
        ReportCategory category = db.getCategory();
        DataReport statsReport = category.createReport("stats");
        DataRow row = statsReport.addRow();
        Map stats = category.getDefaultStats(db, "namespaces", new Filter[0]);
        row.fromMap(stats);
        row.setValue("buildId", (Object)context.getBuild().getId());
        int tests = row.getInt("tests");
        int failures = row.getInt("failures");
        double success_rate = tests == 0 ? 0.0 : (double)(tests - failures) / new Double(tests);
        row.setValue("success_rate", (Object)success_rate);
        category.saveReport(db, statsReport);
    }
}

