/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.nunit.generator;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.io.File;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class NUnitTestProcessor
extends XPathProcessor {
    private static final long serialVersionUID = 1L;

    public NUnitTestProcessor(ReportCategory category) {
        super(category);
    }

    protected void processResource(GeneratorResource resource) {
        Document doc = XMLHelper.readXML((File)resource.getFile());
        XMLHelper.fixNamespaces((Document)doc);
        List nodes = doc.selectNodes("//test-case");
        DataReport report = this.getContext().getDestReport();
        for (Element each : nodes) {
            DataRow row = report.addRow();
            this.processElement(each, row);
        }
    }

    void processElement(Element node, DataRow row) {
        String fullTestName = node.attributeValue("fullname");
        if (Strings.isNullOrEmpty((String)fullTestName)) {
            fullTestName = node.attributeValue("name");
        }
        if (Strings.isNullOrEmpty((String)fullTestName)) {
            throw new IllegalStateException("No test name found. Is this a mal-formed NUnit test report?");
        }
        String testName = ReportUtils.getMethodFromMethodName((String)fullTestName);
        String nsName = ReportUtils.getPackageFromMethodName((String)fullTestName);
        String suiteName = ReportUtils.getClassFromMethodName((String)fullTestName);
        row.setValue("namespace", (Object)nsName);
        row.setValue("suiteName", (Object)suiteName);
        row.setValue("testName", (Object)testName);
        row.setValue("asserts", (Object)XMLHelper.getIntOfXPath((Node)node, (String)"./@asserts"));
        row.setValue("description", (Object)XMLHelper.getStringOfXPath((Node)node, (String)"./@description"));
        row.setValue("duration", (Object)XMLHelper.getLong((Node)node, (String)"./@time * 1000", (Long)0L));
        String message = XMLHelper.getString((Node)node, (String)"./failure/message");
        if (Strings.isNullOrEmpty((String)message)) {
            message = XMLHelper.getString((Node)node, (String)"./reason/message");
        }
        row.setValue("message", (Object)message);
        row.setValue("exceptionStack", (Object)XMLHelper.getString((Node)node, (String)"./failure/stack-trace"));
        row.setValue("status", (Object)this.parseStatus(node).name());
    }

    private Status parseStatus(Element node) {
        String strResult = XMLHelper.getString((Node)node, (String)"./@result");
        Status status = "success".equalsIgnoreCase(strResult) || "passed".equalsIgnoreCase(strResult) ? Status.PASS : ("failed".equalsIgnoreCase(strResult) || "error".equalsIgnoreCase(strResult) || "failure".equalsIgnoreCase(strResult) ? Status.FAIL : Status.SKIP);
        return status;
    }

    static enum Status {
        PASS,
        FAIL,
        SKIP;

    }
}

