/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.nunit.gadget;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.ReportGadgetWithTable;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.nunit.NUnitPlugin;
import com.pmease.quickbuild.plugin.report.nunit.gadget.FailedTestGadgetRenderer;
import java.io.File;
import java.util.ArrayList;

@Editable(name="NUnit Failed Tests", category={"Unit Test Reports"})
public class FailedTestGadget
extends ReportGadgetWithTable {
    private static final long serialVersionUID = 1L;
    private boolean excludingSkippedTests;

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(NUnitPlugin.class);
    }

    protected TableRenderer createTableRenderer() {
        return new FailedTestGadgetRenderer(this.getCategory());
    }

    protected String getToTab() {
        return "Failed Tests";
    }

    protected String[] getActualReportsets() {
        String[] reportsets = super.getActualReportsets();
        if (reportsets == null || reportsets.length == 0) {
            throw new QuickbuildException(this.getNoReportSetErrorMessage());
        }
        ReportCategory category = this.getCategory();
        Build build = Context.getBuild();
        ArrayList actual = Lists.newArrayList();
        for (String each : reportsets) {
            File dbDir = category.getReportDirOfBuild(build, each);
            DataReport report = category.loadReport(dbDir, "stats", new Filter[0]);
            if (report.isEmpty()) continue;
            DataRow row = report.getRow(0);
            int failures = row.getInt("failures");
            int skips = row.getInt("skips");
            if (failures <= 0 && (this.isExcludingSkippedTests() || skips <= 0)) continue;
            actual.add(each);
        }
        if (actual.isEmpty()) {
            throw new QuickbuildException("No failed tests found in specified report sets in build " + build.getVersion());
        }
        return (String[])Iterables.toArray((Iterable)actual, String.class);
    }

    @Editable(name="Excluding Skipped Tests")
    public boolean isExcludingSkippedTests() {
        return this.excludingSkippedTests;
    }

    public void setExcludingSkippedTests(boolean excludingSkippedTests) {
        this.excludingSkippedTests = excludingSkippedTests;
    }
}

