/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.nunit.aggregation;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.aggregation.ReportAggregator;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.nunit.NUnitPlugin;

@Editable(name="NUnit Report")
public class NUnitAggregator
extends ReportAggregator {
    private static final long serialVersionUID = 1L;

    public ReportCategory getCategory() {
        return ReportHelper.getCategory(NUnitPlugin.class);
    }

    static void setSuccessRate(DataRow destRow) {
        int tests = destRow.getInt("tests");
        int failures = destRow.getInt("failures");
        double success_rate = MathUtils.divide((int)(tests - failures), (int)tests);
        destRow.setValue("success_rate", (Object)success_rate);
    }

    protected void aggregateOverview(DataRow sourceRow, DataRow destRow) {
        super.aggregateOverview(sourceRow, destRow);
        NUnitAggregator.setSuccessRate(destRow);
    }

    protected void updateStatsRow(DataRow destRow) {
        super.updateStatsRow(destRow);
        NUnitAggregator.setSuccessRate(destRow);
    }
}

