/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.gitplex;

import com.fasterxml.jackson.core.type.TypeReference;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.scm.gitplex.GitPlexRepoInfo;
import com.pmease.quickbuild.plugin.scm.gitplex.GitPlexRepository;
import com.pmease.quickbuild.repositorysupport.ShortBranch;
import com.pmease.quickbuild.rest.RestModule;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;

@Editable
public class PullRequestVerification
implements Serializable {
    private CommitType commitType = CommitType.HEAD;

    @Editable(name="Commit Type To Verify", description="Specify type of pull request commits to verify. Head commit represents tip commit to be pulled, and merge commit represents merge result of pull request head and target branch head if there is no merge conflict.")
    @NotNull
    public CommitType getCommitType() {
        return this.commitType;
    }

    public void setCommitType(CommitType commitType) {
        this.commitType = commitType;
    }

    public Collection<ShortBranch> getBranches(GitPlexRepository repository) {
        List requests;
        List repositories;
        GitPlexRepoInfo repoInfo = repository.getRepoInfo();
        String query = repoInfo.getUrlRoot() + "/rest/repositories?path=" + repoInfo.getRepoPath();
        WebResource resource = RestModule.resource((String)query, (String)repository.getUserName(), (String)repository.getPassword());
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        if (response.getStatus() != 200) {
            throw new QuickbuildException("Error querying repository: " + (String)response.getEntity(String.class));
        }
        try {
            repositories = (List)GitPlexRepository.objectMapper.readValue((String)response.getEntity(String.class), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        if (repositories.isEmpty()) {
            throw new QuickbuildException("Unable to find GitPlex repository '" + repoInfo.getRepoPath() + "'.");
        }
        if (repositories.size() > 1) {
            throw new QuickbuildException("Found more than one GitPlex repository with path '" + repoInfo.getRepoPath() + "'.");
        }
        Integer repoId = (Integer)((Map)repositories.get(0)).get("id");
        query = repoInfo.getUrlRoot() + "/rest/pull_requests?targetRepoId=" + repoId + "&targetBranch=" + repository.getPullRequestTargetBranch();
        resource = RestModule.resource((String)query, (String)repository.getUserName(), (String)repository.getPassword());
        response = (ClientResponse)resource.get(ClientResponse.class);
        if (response.getStatus() != 200) {
            throw new QuickbuildException("Error querying pull requests: " + (String)response.getEntity(String.class));
        }
        try {
            requests = (List)GitPlexRepository.objectMapper.readValue((String)response.getEntity(String.class), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        ArrayList<ShortBranch> branches = new ArrayList<ShortBranch>();
        for (Map request : requests) {
            ShortBranch shortBranch;
            Map latestUpdate;
            String id = request.get("id").toString();
            if (this.getCommitType() == CommitType.HEAD) {
                latestUpdate = (Map)request.get("latestUpdate");
                shortBranch = new ShortBranch();
                shortBranch.setName(latestUpdate.get("headRef").toString());
                shortBranch.setRevision(latestUpdate.get("headCommitHash").toString());
                shortBranch.setCustomData((Serializable)Long.valueOf(id));
                branches.add(shortBranch);
                continue;
            }
            if (this.getCommitType() == CommitType.MERGE) {
                String integrated;
                Map integrationPreview = (Map)request.get("integrationPreview");
                if (integrationPreview == null || (integrated = (String)integrationPreview.get("integrated")) == null) continue;
                ShortBranch shortBranch2 = new ShortBranch();
                shortBranch2.setCustomData((Serializable)Long.valueOf(id));
                shortBranch2.setName(request.get("integrateRef").toString());
                shortBranch2.setRevision(integrated);
                branches.add(shortBranch2);
                continue;
            }
            latestUpdate = (Map)request.get("latestUpdate");
            shortBranch = new ShortBranch();
            shortBranch.setName(latestUpdate.get("headRef").toString());
            shortBranch.setRevision(latestUpdate.get("headCommitHash").toString());
            shortBranch.setCustomData((Serializable)Long.valueOf(id));
            branches.add(shortBranch);
            Map integrationPreview = (Map)request.get("integrationPreview");
            if (integrationPreview == null) continue;
            String requestHead = (String)integrationPreview.get("requestHead");
            String integrated = (String)integrationPreview.get("integrated");
            if (integrated == null || requestHead.equals(integrated)) continue;
            shortBranch = new ShortBranch();
            shortBranch.setCustomData((Serializable)Long.valueOf(id));
            shortBranch.setName(request.get("integrateRef").toString());
            shortBranch.setRevision(integrated);
            branches.add(shortBranch);
        }
        return branches;
    }

    public static enum CommitType {
        HEAD,
        MERGE,
        BOTH;

    }
}

