/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.gitplex;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.plugin.scm.git.GitRepository;
import com.pmease.quickbuild.plugin.scm.git.GitRevision;
import com.pmease.quickbuild.plugin.scm.gitplex.GitPlexRepoInfo;
import com.pmease.quickbuild.plugin.scm.gitplex.PullRequestVerification;
import com.pmease.quickbuild.repositorysupport.ShortBranch;
import com.pmease.quickbuild.rest.RestModule;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@Editable(name="GitPlex", description="Configure a GitPlex repository here.")
public class GitPlexRepository
extends GitRepository {
    static ObjectMapper objectMapper = new ObjectMapper();
    private PullRequestVerification pullRequestVerification;
    @XStreamOmitField
    private Map<String, String> pullRequestIds;
    private transient GitPlexRepoInfo repoInfo;

    @Editable(name="Pull Request Verification", order=1750, description="Check this to build against open pull requests targeting the branch specified above.")
    @ScriptApi(value="Returns pull request verification definition")
    public PullRequestVerification getPullRequestVerification() {
        return this.pullRequestVerification;
    }

    public void setPullRequestVerification(PullRequestVerification pullRequestVerification) {
        this.pullRequestVerification = pullRequestVerification;
    }

    public Collection<ShortBranch> getShortBranches() {
        if (this.getPullRequestVerification() != null) {
            return this.getPullRequestVerification().getBranches(this);
        }
        return super.getShortBranches();
    }

    public String getActualBranch() {
        if (this.getPullRequestVerification() == null) {
            return super.getActualBranch();
        }
        if (this.getBuild().getRequest().getShortBranch() != null) {
            return this.getBuild().getRequest().getShortBranch().getName();
        }
        throw new QuickbuildException("Unable to determine short branch to build against.");
    }

    String getPullRequestTargetBranch() {
        String branch = this.getBranch();
        if (StringUtils.isEmpty((String)branch)) {
            return "master";
        }
        if (!(branch.contains(" ") || branch.contains("*") || branch.contains("?"))) {
            return branch;
        }
        throw new QuickbuildException("Only one branch can be specified to build against pull requests.");
    }

    GitPlexRepoInfo getRepoInfo() {
        if (this.repoInfo == null) {
            this.repoInfo = GitPlexRepoInfo.fromPullUrl(this.getFetchUrl());
        }
        return this.repoInfo;
    }

    protected void checkoutByRevision(GitRevision revision) {
        super.checkoutByRevision(revision);
        if (this.getPullRequestVerification() == null) {
            return;
        }
        Map<String, Object> verification = this.getVerification(revision);
        if (verification == null) {
            verification = new HashMap<String, Object>();
            verification.put("request", this.getPullRequestId());
            verification.put("configuration", Context.getConfiguration().getPathName());
            verification.put("commit", revision.toString());
        }
        verification.put("status", "ONGOING");
        String message = String.format("Build <a href='%s'>%s</a> is running.", Context.getBuild().getUrl(), Context.getBuild().getVersion());
        verification.put("message", message);
        String verificationPost = this.getRepoInfo().getUrlRoot() + "/rest/verifications";
        WebResource resource = RestModule.resource((String)verificationPost, (String)this.getUserName(), (String)this.getPassword());
        try {
            ClientResponse response = (ClientResponse)resource.type("application/json").post(ClientResponse.class, (Object)objectMapper.writeValueAsString(verification));
            if (response.getStatus() != 200) {
                throw new QuickbuildException("Error posting verification status: " + (String)response.getEntity(String.class));
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    private Map<String, Object> getVerification(GitRevision revision) {
        List verifications;
        String verificationQuery = this.getRepoInfo().getUrlRoot() + "/rest/verifications" + "?requestId=" + this.getPullRequestId() + "&configuration=" + Context.getConfiguration() + "&commit=" + revision;
        WebResource resource = RestModule.resource((String)verificationQuery, (String)this.getUserName(), (String)this.getPassword());
        ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
        if (response.getStatus() != 200) {
            throw new QuickbuildException("Error querying verification: " + (String)response.getEntity(String.class));
        }
        try {
            verifications = (List)objectMapper.readValue((String)response.getEntity(String.class), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        Preconditions.checkState((verifications.size() <= 1 ? 1 : 0) != 0);
        if (verifications.size() == 1) {
            return (Map)verifications.get(0);
        }
        return null;
    }

    public void buildFinished() {
        String message;
        super.buildFinished();
        if (this.getPullRequestVerification() == null) {
            return;
        }
        Map<String, Object> verification = this.getVerification((GitRevision)this.getRevision());
        if (verification == null) {
            verification = new HashMap<String, Object>();
            verification.put("request", this.getPullRequestId());
            verification.put("configuration", Context.getConfiguration().getPathName());
            verification.put("commit", ((GitRevision)this.getRevision()).toString());
        }
        if (Context.getBuild().isSuccessful() || Context.getBuild().isRecommended()) {
            verification.put("status", "PASSED");
            message = String.format("Build <a href='%s'>%s</a> is passed.", Context.getBuild().getUrl(), Context.getBuild().getVersion());
            verification.put("message", message);
        } else {
            verification.put("status", "NOT_PASSED");
            message = String.format("Build <a href='%s'>%s</a> is not passed.", Context.getBuild().getUrl(), Context.getBuild().getVersion());
            verification.put("message", message);
        }
        String verificationPost = this.getRepoInfo().getUrlRoot() + "/rest/verifications";
        WebResource resource = RestModule.resource((String)verificationPost, (String)this.getUserName(), (String)this.getPassword());
        try {
            ClientResponse response = (ClientResponse)resource.type("application/json").post(ClientResponse.class, (Object)objectMapper.writeValueAsString(verification));
            if (response.getStatus() != 200) {
                throw new QuickbuildException("Error posting verification status: " + (String)response.getEntity(String.class));
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    private Long getPullRequestId() {
        return (Long)Context.getRequest().getShortBranch().getCustomData();
    }
}

