/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.step.issueupdater.AbstractScmTaskUpdater;
import com.pmease.quickbuild.plugin.tracker.jira.JiraTracker;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater.JiraIssueUpdater;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.axis.utils.StringUtils;

@Editable(name="Update issues corresponding to changeset closed tasks", order=40)
public class TaskIssuesUpdater
extends AbstractScmTaskUpdater
implements JiraIssueUpdater {
    private static final long serialVersionUID = 1L;
    private String progressStep = "Resolve Issue";
    private transient JiraClient globalClient;

    protected void onBeforeUpdate() {
        super.onBeforeUpdate();
        this.globalClient = JiraClient.newInstance();
    }

    protected void onAfterUpdate() {
        super.onAfterUpdate();
        JiraClient.closeQuietly(this.globalClient);
    }

    @Editable(name="Workflow Action", description="Define a workflow action the issue will trigger. Leave blank to just update issue.", order=1100)
    @ExpressionProvider(value="getAvailableSteps")
    @Scriptable
    public String getProgressStep() {
        return this.progressStep;
    }

    public void setProgressStep(String progressStep) {
        this.progressStep = progressStep;
    }

    private boolean isProgress() {
        return !StringUtils.isEmpty((String)this.getProgressStep());
    }

    protected void executeCommand() {
        if (!this.isProgress() && this.extraAttributes.isEmpty()) {
            return;
        }
        if (this.isProgress()) {
            this.currentCommand.addOption("step", this.getProgressStep());
            this.globalClient.progressWorkflow(this.currentCommand.getIssue(), this.currentCommand.getOptions());
        } else {
            this.globalClient.updateIssue(this.currentCommand.getIssue(), this.currentCommand.getOptions());
        }
    }

    protected AbstractIssueTracker getTracker() {
        return new JiraTracker();
    }

    private static Map<String, String> getAvailableSteps() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("Resolve Issue", "Resolve Issue");
        map.put("Close Issue", "Close Issue");
        map.put("Start Progress", "Start Progress");
        map.put("Stop Progress", "Stop Progress");
        map.put("Reopen Issue", "Reopen Issue");
        return map;
    }
}

