/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater.AbstractIssueListUpdater;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Update issues with specified keys", order=30)
public class SpecifiedIssuesUpdater
extends AbstractIssueListUpdater {
    private static final long serialVersionUID = 1L;
    private String keyList;

    @Editable(name="Issue keys", order=100)
    @NotEmpty
    @Scriptable
    public String getKeyList() {
        return this.keyList;
    }

    public void setKeyList(String keys) {
        this.keyList = keys;
    }

    public Set<String> getIssueKeys() {
        if (StringUtils.isEmpty((String)this.getKeyList())) {
            return Collections.emptySet();
        }
        String[] keys = StringUtils.split((String)this.getKeyList());
        if (keys.length == 0) {
            Context.getLogger().info("No issue keys found from issue list.");
        }
        return new LinkedHashSet<String>(Arrays.asList(keys));
    }
}

