/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater.AbstractIssueListUpdater;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.validator.constraints.NotEmpty;
import org.swift.common.soap.jira.RemoteIssue;

@Editable(name="Update issues filtered by JQL", order=30)
public class JqlUpdater
extends AbstractIssueListUpdater {
    private static final long serialVersionUID = 1L;
    private String jql;

    @Editable(name="JQL", order=100, description="The JQL to be executed")
    @NotEmpty
    @Scriptable
    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getIssueKeys() {
        JiraClient client = JiraClient.newInstance();
        try {
            RemoteIssue[] issues = client.getIssuesFromJql(this.getJql());
            if (issues == null || issues.length == 0) {
                Context.getLogger().info("No issues found! JQL: [" + this.getJql() + "].");
                Set<String> set = Collections.emptySet();
                return set;
            }
            LinkedHashSet<String> keys = new LinkedHashSet<String>(issues.length);
            for (RemoteIssue each : issues) {
                keys.add(each.getKey());
            }
            LinkedHashSet<String> linkedHashSet = keys;
            return linkedHashSet;
        }
        finally {
            JiraClient.closeQuietly(client);
        }
    }
}

