/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommitCommand;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommitCommandDef;
import com.pmease.quickbuild.plugin.tracker.core.step.issueupdater.AbstractCommitCommandUpdater;
import com.pmease.quickbuild.plugin.tracker.jira.JiraHelper;
import com.pmease.quickbuild.plugin.tracker.jira.JiraIssue;
import com.pmease.quickbuild.plugin.tracker.jira.JiraTracker;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.plugin.tracker.jira.setting.JiraCommandDef;
import com.pmease.quickbuild.plugin.tracker.jira.setting.JiraSetting;
import com.pmease.quickbuild.plugin.tracker.jira.step.UpdateIssueStep;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater.JiraIssueUpdater;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Size;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.swift.common.soap.jira.RemoteIssue;
import org.swift.common.soap.jira.RemoteIssueType;
import org.swift.common.soap.jira.RemotePriority;
import org.swift.common.soap.jira.RemoteResolution;
import org.swift.common.soap.jira.RemoteStatus;

@Editable(name="Update issues according to commit commands", order=10)
public class JiraCommandUpdater
extends AbstractCommitCommandUpdater
implements JiraIssueUpdater {
    private static final long serialVersionUID = 1L;
    private boolean forceUpdate = false;
    private List<JiraCommandDef> commandDefs;
    private transient JiraClient globalClient;
    private transient RemotePriority[] remotePriorities;
    private transient RemoteStatus[] remoteStatuses;
    private transient RemoteResolution[] remoteResolutions;
    private transient RemoteIssueType[] remoteTypes;

    protected AbstractIssueTracker createTracker() {
        return new JiraTracker();
    }

    protected void onBeforeUpdate() {
        super.onBeforeUpdate();
        this.globalClient = JiraClient.newInstance();
        this.remotePriorities = this.globalClient.getPriorities();
        this.remoteStatuses = this.globalClient.getStatuses();
        this.remoteResolutions = this.globalClient.getResolutions();
        this.remoteTypes = this.globalClient.getIssueTypes();
    }

    protected void onAfterUpdate() {
        super.onAfterUpdate();
        JiraClient.closeQuietly(this.globalClient);
    }

    protected void executeCommand() {
        JiraSetting setting;
        Logger logger = Context.getLogger();
        CommitCommand command = this.getCurrentCommand();
        String issueKey = command.getIssue().toUpperCase();
        if (!JiraHelper.isIssueInProject(issueKey, (setting = (JiraSetting)this.trackerSetting).getAssociatedProject())) {
            logger.info("Issue " + issueKey + " doesn't belong to project " + setting.getAssociatedProject());
            return;
        }
        RemoteIssue issue = this.globalClient.getIssue(issueKey);
        Date commitDate = command.getDate();
        Calendar updated = issue.getUpdated();
        if (!this.forceUpdate && !this.updatedIssues.contains(issueKey) && updated != null && updated.getTime().after(commitDate)) {
            throw new TrackerException("This issue has been updated after commit.");
        }
        if (!this.needUpdate(issue)) {
            logger.debug("Updating issue [" + issueKey + "] ignored due to not matching updating condition ");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Updating issue [" + issueKey + "] via command: " + command);
        }
        if (this.isProgressCommand(command)) {
            this.globalClient.progressWorkflow(issueKey, command.getOptions());
        } else {
            this.globalClient.updateIssue(issueKey, command.getOptions());
        }
    }

    protected boolean needUpdate(RemoteIssue issue) {
        UpdateIssueStep s = (UpdateIssueStep)this.step;
        if (StringUtils.isBlank((String)s.getUpdateCondition())) {
            return true;
        }
        return (Boolean)ScriptEngine.instance.evaluate(s.getUpdateCondition(), (Map)ImmutableMap.builder().put((Object)"issue", (Object)JiraIssue.of(issue, this.remoteStatuses, this.remotePriorities, this.remoteResolutions, this.remoteTypes)).build());
    }

    private boolean isProgressCommand(CommitCommand command) {
        return !StringUtils.isEmpty((String)command.getOptionValue("step"));
    }

    protected void initCommandDefs() {
        this.commandDefs = new ArrayList<JiraCommandDef>();
        this.commandDefs.add(new JiraCommandDef("update", ""));
        this.commandDefs.add(new JiraCommandDef("accept", "assignee=${step.getTrackerUser()}"));
        this.commandDefs.add(new JiraCommandDef("start", "step=Start Progress"));
        this.commandDefs.add(new JiraCommandDef("stop", "step=Stop Progress"));
        this.commandDefs.add(new JiraCommandDef("reopen", "step=Reopen Issue"));
        this.commandDefs.add(new JiraCommandDef("fix", "step=Resolve Issue"));
        this.commandDefs.add(new JiraCommandDef("close", "step=Close Issue"));
    }

    protected List<? extends CommitCommandDef> getCommitCommandDefs() {
        return this.getCommandDefs();
    }

    @Editable(name="Commit Commands", order=1500, description="QuickBuild will search for defined commands in SCM commit messages, and update associated issues using specified attributes. For example, if command \"fix\" is defined to set step to \"Resolve Issue\", occurrence of \"fix TST-123\" in commit messages will be interpreted as resolving issue \"TST-123\" in current build. Refer to <a href=\"$docroot/Commit+Command\" target=\"_blank\">command syntax</a> on how to use defined commands in commit messages.<br/><strong>NOTE:</strong> Commit commands are case-insensitive.")
    @Size(min=1, max=1000)
    @NotEmpty
    @Scriptable
    @ScriptApi
    public List<JiraCommandDef> getCommandDefs() {
        return this.commandDefs;
    }

    public void setCommandDefs(List<JiraCommandDef> commandDefs) {
        this.commandDefs = commandDefs;
    }

    @Editable(name="Force Update", order=1400, description="Force update issue even it was changed after commit.")
    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }
}

