/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater.AbstractIssueListUpdater;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.constraints.NotEmpty;
import org.swift.common.soap.jira.RemoteFilter;
import org.swift.common.soap.jira.RemoteIssue;

@Editable(name="Update issues filtered by specified JIRA filter", order=20)
public class FilteredIssuesUpdater
extends AbstractIssueListUpdater {
    private static final long serialVersionUID = 1L;
    private String filter;

    @Editable(name="Filter", order=100)
    @ExpressionProvider(value="getSavedFilters")
    @NotEmpty
    @Scriptable
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getIssueKeys() {
        JiraClient client = JiraClient.newInstance();
        try {
            RemoteIssue[] issues = client.getIssuesFromFilter(this.getFilter());
            if (issues == null || issues.length == 0) {
                Context.getLogger().info("No issues found! Filter: '" + this.getFilter() + "'.");
                Set<String> set = Collections.emptySet();
                return set;
            }
            LinkedHashSet<String> keys = new LinkedHashSet<String>(issues.length);
            for (RemoteIssue each : issues) {
                keys.add(each.getKey());
            }
            LinkedHashSet<String> linkedHashSet = keys;
            return linkedHashSet;
        }
        finally {
            JiraClient.closeQuietly(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getSavedFilters() {
        JiraClient client = JiraClient.newInstance();
        try {
            RemoteFilter[] filters = client.getSavedFilters();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (RemoteFilter f : filters) {
                map.put(f.getName(), f.getName());
            }
            LinkedHashMap<String, String> linkedHashMap = map;
            return linkedHashMap;
        }
        finally {
            JiraClient.closeQuietly(client);
        }
    }
}

