/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater;

import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import com.pmease.quickbuild.plugin.tracker.jira.JiraTracker;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater.AbstractIssueListUpdater;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater.JiraIssueUpdater;
import com.pmease.quickbuild.repositorysupport.BuildChangeset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

@Editable(name="Update issues mentioned in commit messages", order=40)
public class CommitMessageUpdater
extends AbstractIssueListUpdater
implements JiraIssueUpdater {
    private static final long serialVersionUID = 1L;

    protected Set<String> getIssueKeys() {
        Build build = Context.getBuild();
        List changes = TrackerHelper.getChangesSincePreviousSuccessful((Build)build);
        Logger logger = Context.getLogger();
        if (changes.isEmpty()) {
            logger.info("No changes found since previous successful build");
            return Collections.emptySet();
        }
        JiraTracker tracker = new JiraTracker();
        HashSet keys = Sets.newHashSet();
        for (BuildChangeset each : changes) {
            keys.addAll(tracker.extractIssueKeys(each.getComment()));
        }
        return keys;
    }
}

