/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.jira.JiraIssue;
import com.pmease.quickbuild.plugin.tracker.jira.JiraPlugin;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.plugin.tracker.jira.step.UpdateIssueStep;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater.JiraIssueUpdater;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.swift.common.soap.jira.RemoteIssue;
import org.swift.common.soap.jira.RemoteIssueType;
import org.swift.common.soap.jira.RemotePriority;
import org.swift.common.soap.jira.RemoteResolution;
import org.swift.common.soap.jira.RemoteStatus;

public abstract class AbstractIssueListUpdater
extends com.pmease.quickbuild.plugin.tracker.core.step.issueupdater.AbstractIssueListUpdater
implements JiraIssueUpdater {
    private static final long serialVersionUID = 1L;
    private String progressStep = "Resolve Issue";
    private transient JiraClient globalClient;
    private transient RemotePriority[] remotePriorities;
    private transient RemoteStatus[] remoteStatuses;
    private transient RemoteResolution[] remoteResolutions;
    private transient RemoteIssueType[] remoteTypes;

    @Editable(name="Workflow Action", description="Define a workflow action the issue will trigger. Leave blank to do nothing.", order=1100)
    @ExpressionProvider(value="getAvailableSteps")
    @Scriptable
    public String getProgressStep() {
        return this.progressStep;
    }

    public void setProgressStep(String progressStep) {
        this.progressStep = progressStep;
    }

    protected Class<? extends AbstractPlugin> getPluginClass() {
        return JiraPlugin.class;
    }

    protected void onBeforeUpdate() {
        super.onBeforeUpdate();
        this.globalClient = JiraClient.newInstance();
        this.remotePriorities = this.globalClient.getPriorities();
        this.remoteStatuses = this.globalClient.getStatuses();
        this.remoteResolutions = this.globalClient.getResolutions();
        this.remoteTypes = this.globalClient.getIssueTypes();
    }

    protected boolean needUpdate(Issue issue) {
        UpdateIssueStep s;
        String updateCondition;
        if (this.isProgress()) {
            this.attributes.put("step", this.getProgressStep());
        }
        if (!Strings.isNullOrEmpty((String)(updateCondition = (s = (UpdateIssueStep)this.step).getUpdateCondition()))) {
            JiraIssue i = (JiraIssue)issue;
            return (Boolean)ScriptEngine.instance.evaluate(updateCondition, (Map)ImmutableMap.of((Object)"issue", (Object)((Object)JiraIssue.of(i.getRemoteIssue(), this.remoteStatuses, this.remotePriorities, this.remoteResolutions, this.remoteTypes))));
        }
        return true;
    }

    private boolean isProgress() {
        return !StringUtils.isEmpty((String)this.getProgressStep());
    }

    protected void onAfterUpdate() {
        JiraClient.closeQuietly(this.globalClient);
    }

    protected Issue getIssue(String key) {
        try {
            RemoteIssue remoteIssue = this.globalClient.getIssue(key);
            if (remoteIssue != null) {
                return new JiraIssue(remoteIssue);
            }
        }
        catch (TrackerException e) {
            Context.getLogger().warn("Fetch issue " + key + " failed.", (Throwable)e);
        }
        return null;
    }

    protected String getUpdateAction() {
        if (this.isProgress()) {
            return "progress";
        }
        return super.getUpdateAction();
    }

    protected void updateIssue(String key, Map<String, String> attributes) {
        if (this.isProgress()) {
            this.globalClient.progressWorkflow(key, attributes);
        } else {
            this.globalClient.updateIssue(key, attributes);
        }
    }

    private static Map<String, String> getAvailableSteps() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("Resolve Issue", "Resolve Issue");
        map.put("Close Issue", "Close Issue");
        map.put("Start Progress", "Start Progress");
        map.put("Stop Progress", "Stop Progress");
        map.put("Reopen Issue", "Reopen Issue");
        return map;
    }
}

