/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.step.issueprovider;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueprovider.JiraIssueProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.validator.constraints.NotEmpty;
import org.swift.common.soap.jira.RemoteIssue;

@Editable(name="Issues filtered by specified JQL", order=30)
public class JqlIssuesProvider
implements JiraIssueProvider {
    private static final long serialVersionUID = 1L;
    private String jql;

    @Editable(name="JQL", order=100, description="The JQL to be executed")
    @NotEmpty
    @Scriptable
    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getIssueKeys() {
        JiraClient client = JiraClient.newInstance();
        try {
            RemoteIssue[] issues = client.getIssuesFromJql(this.getJql());
            if (issues == null || issues.length == 0) {
                Context.getLogger().info("No issues found! JQL: [" + this.getJql() + "].");
                Set<String> set = Collections.emptySet();
                return set;
            }
            HashSet<String> keys = new HashSet<String>();
            for (RemoteIssue each : issues) {
                keys.add(each.getKey());
            }
            HashSet<String> hashSet = keys;
            return hashSet;
        }
        finally {
            JiraClient.closeQuietly(client);
        }
    }
}

