/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.step.issueprovider;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueprovider.JiraIssueProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.constraints.NotEmpty;
import org.swift.common.soap.jira.RemoteFilter;
import org.swift.common.soap.jira.RemoteIssue;

@Editable(name="Issues filtered by specified JIRA filter", order=20)
public class FilteredIssuesProvider
implements JiraIssueProvider {
    private static final long serialVersionUID = 1L;
    private String filter;

    @Editable(name="Filter", order=1000)
    @ExpressionProvider(value="getSavedFilters")
    @NotEmpty
    @Scriptable
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getSavedFilters() {
        JiraClient client = JiraClient.newInstance();
        try {
            RemoteFilter[] filters = client.getSavedFilters();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (RemoteFilter f : filters) {
                map.put(f.getName(), f.getName());
            }
            LinkedHashMap<String, String> linkedHashMap = map;
            return linkedHashMap;
        }
        finally {
            JiraClient.closeQuietly(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getIssueKeys() {
        JiraClient client = JiraClient.newInstance();
        try {
            RemoteIssue[] issues = client.getIssuesFromFilter(this.getFilter());
            if (issues == null || issues.length == 0) {
                Context.getLogger().info("No issues found! Filter: '" + this.getFilter() + "'.");
                Set<String> set = Collections.emptySet();
                return set;
            }
            HashSet<String> keys = new HashSet<String>();
            for (RemoteIssue each : issues) {
                keys.add(each.getKey());
            }
            HashSet<String> hashSet = keys;
            return hashSet;
        }
        finally {
            JiraClient.closeQuietly(client);
        }
    }
}

