/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.step;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractUpdateIssueStep;
import com.pmease.quickbuild.plugin.tracker.core.step.issueupdater.IssueUpdater;
import com.pmease.quickbuild.plugin.tracker.jira.JiraPlugin;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater.IssueUpdaterWrapper;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater.JiraCommandUpdater;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.validation.constraints.Size;
import org.dom4j.Element;

@Editable(name="Update JIRA Issues", category={"Issue Tracker"}, description="This step updates JIRA issues based on commit commands  found in SCM commit messages since previous successful build, JIRA filter, JQL search or any specified issue list<br/><strong>NOTE:</strong><ul class=\"square\">   <li>This step should be arranged to run before the \"release version\" step if you want to    release this build into JIRA.</li>\t<li>The issues are updated by the account which is specified in the JIRA setting</li>\t<li>If issues to be updated are based on commit commands, the issues updated manually after commit will not be processed here.</li>\t<li>Only issues belonging to associated JIRA project will be processed.</li></ul>")
@ScriptApi(value="This step updates JIRA issues based commit commands found in SCM commit messages since previous successful build.")
public class UpdateIssueStep
extends AbstractUpdateIssueStep {
    private static final long serialVersionUID = 1L;
    private List<IssueUpdaterWrapper> updaterWrappers = new ArrayList<IssueUpdaterWrapper>();
    private String updateCondition;

    public UpdateIssueStep() {
        IssueUpdaterWrapper wrapper = new IssueUpdaterWrapper();
        wrapper.setUpdater(new JiraCommandUpdater());
        this.updaterWrappers.add(wrapper);
    }

    @Editable(name="Extra Attributes", order=1600, description="Optionally specify extra attributes for updating issues, with one attribute per line. For example:<br/><code>owner=admin<br/>version=some_version</code><strong>NOTE: </strong>The attribute specified here will be overrided by the same attribute specified in commit command definition and option.<br/>Reference <a href=\"$docroot/Integrating+JIRA+with+QuickBuild\" target=\"_default\">here</a> for available attributes.")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get extra attributes for all the commit commands.")
    public String getExtraAttributes() {
        return super.getExtraAttributes();
    }

    public List<IssueUpdater> getUpdaters() {
        ArrayList<IssueUpdater> updaters = new ArrayList<IssueUpdater>();
        for (IssueUpdaterWrapper each : this.getUpdaterWrappers()) {
            updaters.add(each.getUpdater());
        }
        return updaters;
    }

    @Editable(name="Specify How to Update Issues", order=1000)
    @Size(min=1, max=10000)
    public List<IssueUpdaterWrapper> getUpdaterWrappers() {
        return this.updaterWrappers;
    }

    public void setUpdaterWrappers(List<IssueUpdaterWrapper> updaterWrappers) {
        this.updaterWrappers = updaterWrappers;
    }

    public Class<? extends AbstractTrackerPlugin> getPluginClass() {
        return JiraPlugin.class;
    }

    @Editable(name="Update issues on condition", description="Specifies the boolean condition to update a issues. For example, issue.statusName==\"open\".<br/>Available issue properties include: <br/>issueKey, assignee, reporter, status, priority, resolution, issueType, summary, updated, created, fixVersions, affectsVersions.<br>Relevant issues will be updated if this condition leaves undefined.", order=1700)
    @Scriptable
    @ScriptApi(value="The condition for updating issues")
    public String getUpdateCondition() {
        return this.updateCondition;
    }

    public void setUpdateCondition(String updateCondition) {
        this.updateCondition = updateCondition;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element commandDefsElement = dom.getRootElement().element("commandDefs");
        commandDefsElement.detach();
        Element updaterWrappersElement = dom.getRootElement().addElement("updaterWrappers");
        Element wrapperElement = updaterWrappersElement.addElement("com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater.IssueUpdaterWrapper");
        Element updaterElement = wrapperElement.addElement("updater");
        updaterElement.addAttribute("class", "com.pmease.quickbuild.plugin.tracker.jira.step.issueupdater.JiraCommandUpdater");
        updaterElement.add(commandDefsElement);
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("updateCondition");
    }
}

