/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.step;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.IssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractReleaseVersionStep;
import com.pmease.quickbuild.plugin.tracker.core.step.issueprovider.IssueProvider;
import com.pmease.quickbuild.plugin.tracker.jira.JiraHelper;
import com.pmease.quickbuild.plugin.tracker.jira.JiraPlugin;
import com.pmease.quickbuild.plugin.tracker.jira.JiraTracker;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.plugin.tracker.jira.setting.JiraSetting;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueprovider.CommitMessageProvider;
import com.pmease.quickbuild.plugin.tracker.jira.step.issueprovider.IssueProviderWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.swift.common.soap.jira.RemoteStatus;

@Editable(name="Release JIRA Version", category={"Issue Tracker"}, description="This step will release current build version in associated JIRA project. Version will be created at JIRA side if it does not exist already. This step will also associate recent resolved issues with current version via \"fix version/s\" field.<br/><strong>NOTE:</strong><ul class=\"square\">\t<li>The \"fix Version/s\" field will be updated only for issues belonging to associated JIRA project with Resolved/Closed status.</li>\t<li>The user defined in JIRA Setting must have permission to administer project and edit project issues.    Please note that by default users assigned to jira-administrators group does not have permission to    edit project issues unless they are also assigned to jira-developers group.</li></ul>")
public class ReleaseVersionStep
extends AbstractReleaseVersionStep {
    private static final long serialVersionUID = 1L;
    private List<IssueProviderWrapper> wrappers = new ArrayList<IssueProviderWrapper>();
    private transient JiraClient client;
    private transient String projectKey;
    private String acceptedStatuses;
    private transient Set<String> closedStatuses;
    private static final Set<String> DEFAULT_STATUSES = ImmutableSet.of((Object)"resolved", (Object)"closed", (Object)"done");

    public ReleaseVersionStep() {
        IssueProviderWrapper wrapper = new IssueProviderWrapper();
        wrapper.setProvider(new CommitMessageProvider());
        this.wrappers.add(wrapper);
    }

    @Editable(name="Issues to Update 'Fix Version/s' Field", order=1000, description="Specify issues whose <i>Fix Version/s</i> field will be updated to reflect this released version.")
    public List<IssueProviderWrapper> getWrappers() {
        return this.wrappers;
    }

    public void setWrappers(List<IssueProviderWrapper> wrappers) {
        this.wrappers = wrappers;
    }

    @Editable(order=1200, name="Extra Attributes", description="Optionally specify extra attributes when update the \"fix version/s\" field of applicable issues, with one attribute per line. For example:<br/><code>reporter=admin<br/>affectsVersions=some_version</code>Reference <a href=\"$docroot/Integrating+JIRA+with+QuickBuild\" target=\"_default\">here</a> for available attributes.")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get extra attributes used when update the \"fix version/s\" field of applicable issues.")
    public String getExtraAttributes() {
        return super.getExtraAttributes();
    }

    @Editable(order=2000, name="Issues with status", description="Optionally specify the issue status with which the issues can be updated. Comma to separate each status. By default, the status is: Resolved, Closed, Done.")
    public String getAcceptedStatuses() {
        return this.acceptedStatuses;
    }

    public void setAcceptedStatuses(String acceptedStatuses) {
        this.acceptedStatuses = acceptedStatuses;
    }

    private Set<String> acceptedStatuses() {
        String str = this.getAcceptedStatuses();
        if (Strings.isNullOrEmpty((String)str)) {
            return DEFAULT_STATUSES;
        }
        HashSet set = Sets.newHashSet((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)str));
        if (set.isEmpty()) {
            return DEFAULT_STATUSES;
        }
        HashSet result = Sets.newHashSet();
        for (String each : set) {
            result.add(each.toLowerCase());
        }
        return result;
    }

    protected void onBeforeRelease() {
        this.client = JiraClient.newInstance();
        JiraSetting setting = JiraSetting.get(Context.getConfiguration());
        this.projectKey = setting.getAssociatedProject();
        Set<String> accepted = this.acceptedStatuses();
        RemoteStatus[] statuses = this.client.getStatuses();
        this.closedStatuses = Sets.newHashSet();
        for (RemoteStatus each : statuses) {
            if (!accepted.contains(each.getName().toLowerCase())) continue;
            this.closedStatuses.add(each.getId());
        }
        super.onBeforeRelease();
    }

    protected void onAfterRelease() {
        JiraClient.closeQuietly(this.client);
        super.onAfterRelease();
    }

    protected List<IssueProvider> getProviders() {
        ArrayList<IssueProvider> providers = new ArrayList<IssueProvider>();
        for (IssueProviderWrapper wrapper : this.getWrappers()) {
            providers.add(wrapper.getProvider());
        }
        return providers;
    }

    protected void releaseVersion() {
        if (StringUtils.isEmpty((String)this.projectKey)) {
            throw new QuickbuildException("At least one project should be defined in configuration settings -> JIRA Server.");
        }
        if (!this.client.hasProject(this.projectKey)) {
            throw new QuickbuildException("The project key [" + this.projectKey + "] is not defined in JIRA server " + this.client.getServerUrl());
        }
        String version = Context.getBuild().getVersion();
        Context.getLogger().info("Release version - " + version + " to JIRA project " + this.projectKey + " ... ");
        this.client.releaseVersion(this.projectKey, version);
    }

    protected void updateIssue(String key) {
        if (JiraHelper.isIssueInProject(key, this.projectKey)) {
            this.client.updateFixVersions(key, Context.getBuild().getVersion(), this.closedStatuses, this.attributes);
        }
    }

    public Class<? extends AbstractTrackerPlugin> getPluginClass() {
        return JiraPlugin.class;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        versions.push(0);
        Element wrappersElement = dom.getRootElement().addElement("wrappers");
        Element wrapperElement = wrappersElement.addElement("com.pmease.quickbuild.plugin.tracker.jira.step.issueprovider.IssueProviderWrapper");
        wrapperElement.addElement("provider").addAttribute("class", "com.pmease.quickbuild.plugin.tracker.jira.step.issueprovider.CommitMessageProvider");
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("acceptedStatuses");
    }

    protected IssueTracker getIssueTracker() {
        return new JiraTracker();
    }
}

