/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.step;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.annotation.Template;
import com.pmease.quickbuild.log.VelocityLogger;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommandParser;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import com.pmease.quickbuild.plugin.tracker.jira.JiraPlugin;
import com.pmease.quickbuild.plugin.tracker.jira.JiraTracker;
import com.pmease.quickbuild.repositorysupport.BuildChangeset;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.VelocityUtils;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="JIRA Release Notes", category={"Issue Tracker"}, description="This step is to create JIRA release notes via evaluating specified Velocity template and save the result as a file which can be published as artifacts.")
@ScriptApi(value="Create JRIA release notes via evaluating a specified template and save the result to specified file.")
public class ReleaseNotesStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String template = ReportHelper.readClassResource(ReleaseNotesStep.class, (String)"ReleaseNotes.vm");
    private String saveAs;

    @Editable(order=1000, description="Specify a <a href=\"http://velocity.apache.org\">Velocity</a> template here. Evaluation result of the template will be saved to the file specified below. Resource load path will be set to current configuration's workspace directory when this template is evaluated. Also refer to template context help below for objects contained in the Velocity context.")
    @NotEmpty
    @Multiline(value=10)
    @ScriptApi(value="Get template to evaluate.")
    @Template
    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @Editable(order=1100, description="Specify the file path relative to current workspace which is used to save the template evaluation result.")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get file path to save evaluation result as.")
    public String getSaveAs() {
        return this.saveAs;
    }

    public void setSaveAs(String saveAs) {
        this.saveAs = saveAs;
    }

    public void run() {
        List<Issue> issues = this.getIssues(Context.getBuild());
        if (issues.isEmpty()) {
            Context.getLogger().warn("No issues found in current build, ignore creating JIRA release notes.");
            return;
        }
        try {
            VelocityEngine engine = new VelocityEngine();
            engine.setProperty("file.resource.loader.path", (Object)Context.getConfiguration().getWorkspaceDir().getAbsolutePath());
            engine.setProperty("runtime.log.logsystem", (Object)new VelocityLogger());
            engine.init();
            StringWriter writer = new StringWriter();
            HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
            map.put("issues", issues);
            map.put("build", (List<Object>)Context.getBuild());
            VelocityContext evalContext = VelocityUtils.buildEvalContext((Map)Context.buildEvalContext((Object)((Object)this), map));
            engine.evaluate((org.apache.velocity.context.Context)evalContext, (Writer)writer, "JIRA-RELEASE-NOTES", this.template);
            FileUtils.writeFile((File)new File(Context.getConfiguration().getWorkspaceDir(), this.getSaveAs()), (String)writer.toString());
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapException((String)"Failed to evaluate Velocity template.", (Throwable)e);
        }
    }

    private List<Issue> getIssues(Build build) {
        List changes = build.getChanges();
        JiraTracker tracker = new JiraTracker();
        LinkedHashSet<Object> issueKeys = new LinkedHashSet<Object>();
        ReportCategory category = ReportHelper.getCategory(JiraPlugin.class);
        Map issueActions = TrackerHelper.getIssueActions((ReportCategory)category);
        Pattern pIssue = tracker.getIssuePattern();
        for (BuildChangeset each : changes) {
            String comment = each.getComment();
            List matched = CommandParser.getMatchedIssues((String)comment, (Pattern)pIssue);
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (String key : matched) {
                keys.add(tracker.extractIssueKey(key));
            }
            issueKeys.addAll(keys);
        }
        issueKeys.addAll(issueActions.keySet());
        Map issues = tracker.fetchIssues(issueKeys);
        ArrayList<Issue> result = new ArrayList<Issue>(issues.values());
        Collections.sort(result, new Comparator<Issue>(){

            @Override
            public int compare(Issue o1, Issue o2) {
                Calendar date1 = o1.getCreated();
                Calendar date2 = o2.getUpdated();
                if (date1 == null) {
                    return 1;
                }
                if (date2 == null) {
                    return -1;
                }
                return date2.compareTo(date1);
            }
        });
        return result;
    }
}

