/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.step;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractIssueStep;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.jira.JiraPlugin;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.plugin.tracker.jira.setting.JiraSetting;
import com.pmease.quickbuild.setting.step.executecondition.AnyPreviousSiblingStepFailed;
import com.pmease.quickbuild.setting.step.executecondition.ExecuteCondition;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.axis.utils.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;
import org.swift.common.soap.jira.RemoteIssue;
import org.swift.common.soap.jira.RemoteIssueType;
import org.swift.common.soap.jira.RemotePriority;

@Editable(name="Create JIRA Issues", category={"Issue Tracker"}, description="This step can be used to create issue in associated JIRA project.")
public class CreateIssueStep
extends AbstractIssueStep {
    private static final long serialVersionUID = 1L;
    private String issueType;
    private String issueSummary;
    private String issueDescription;
    private String issuePriority;
    private String assignee;

    public CreateIssueStep() {
        this.setExecuteCondition((ExecuteCondition)new AnyPreviousSiblingStepFailed());
        this.issueSummary = "Build ${build.getVersion()} failed!";
        this.issueType = "Bug";
        this.issuePriority = "Major";
    }

    @Editable(order=1100, description="Specify the issue type")
    @ExpressionProvider(value="getAvailableTypes")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get issue type.")
    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    @Editable(name="Issue Summary", order=1200, description="Specify the issue summary")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get issue summary.")
    public String getIssueSummary() {
        return this.issueSummary;
    }

    public void setIssueSummary(String issueSummary) {
        this.issueSummary = issueSummary;
    }

    @Editable(name="Issue Description", order=1300, description="Optionally specify the issue description")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get issue description.")
    public String getIssueDescription() {
        return this.issueDescription;
    }

    public void setIssueDescription(String issueDescription) {
        this.issueDescription = issueDescription;
    }

    @Editable(name="Issue Priority", order=1400, description="Optionally specify the issue priority")
    @ExpressionProvider(value="getAvailablePriorities")
    @Scriptable
    @ScriptApi(value="Get issue priority.")
    public String getIssuePriority() {
        return this.issuePriority;
    }

    public void setIssuePriority(String issuePriority) {
        this.issuePriority = issuePriority;
    }

    @Editable(order=1600, name="Extra Attributes", description="Optionally specify extra attributes of the issue, with one attribute per line. For example:<br/><code>reporter=admin<br/>affectsVersions=some_version</code>Reference <a href=\"$docroot/Integrating+QuickBuild+with+JIRA\" target=\"_default\">here</a> for available attributes.")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get extra attributes of the issue.")
    public String getExtraAttributes() {
        return super.getExtraAttributes();
    }

    @Editable(order=1500, name="Assign to", description="Optionally specify assignee of this issue. If leave empty, the default assignee defined in the associated project will be used.")
    @Scriptable
    @ScriptApi(value="Get the assignee of this issue.")
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getAvailableTypes() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        JiraSetting server = JiraSetting.get(Context.getConfiguration());
        if (server == null) {
            return Collections.emptyMap();
        }
        JiraClient client = null;
        try {
            client = JiraClient.newInstance();
            RemoteIssueType[] types = null;
            types = client.getIssueTypesForProject(server.getAssociatedProject(), false);
            if (types.length == 0) {
                map.put("Bug", "Bug");
                map.put("Improvement", "Improvement");
                map.put("New Feature", "New Feature");
                map.put("Task", "Task");
            } else {
                for (RemoteIssueType type : types) {
                    map.put(type.getName(), type.getName());
                }
            }
            LinkedHashMap<String, String> linkedHashMap = map;
            return linkedHashMap;
        }
        catch (TrackerException e) {
            map.put("Bug", "Bug");
            map.put("Improvement", "Improvement");
            map.put("New Feature", "New Feature");
            map.put("Task", "Task");
            LinkedHashMap<String, String> linkedHashMap = map;
            return linkedHashMap;
        }
        finally {
            if (client != null) {
                client.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getAvailablePriorities() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        JiraClient client = null;
        try {
            client = JiraClient.newInstance();
            RemotePriority[] priorities = client.getPriorities();
            if (priorities == null || priorities.length == 0) {
                map.put("Blocker", "Blocker");
                map.put("Critical", "Critical");
                map.put("Major", "Major");
                map.put("Minor", "Minor");
                map.put("Trivial", "Trivial");
            } else {
                for (RemotePriority each : priorities) {
                    map.put(each.getName(), each.getName());
                }
            }
            LinkedHashMap<String, String> linkedHashMap = map;
            return linkedHashMap;
        }
        catch (TrackerException e) {
            map.put("Blocker", "Blocker");
            map.put("Critical", "Critical");
            map.put("Major", "Major");
            map.put("Minor", "Minor");
            map.put("Trivial", "Trivial");
            LinkedHashMap<String, String> linkedHashMap = map;
            return linkedHashMap;
        }
        finally {
            if (client != null) {
                client.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        JiraSetting server = JiraSetting.get(Context.getConfiguration());
        if (server == null) {
            throw new QuickbuildException("JIRA setting is not configured correctly in the configuration. To configure JIRA setting, please go to Configuration settings -> JIRA Server tab panel.");
        }
        JiraClient client = null;
        try {
            String assignee;
            String description;
            this.onBeforeRun();
            client = JiraClient.newInstance();
            String extraOptions = this.getExtraAttributes();
            Map options = StringHelper.getOptionsFromDefinition((String)extraOptions);
            options.put("project", server.getAssociatedProject());
            options.put("summary", this.getIssueSummary());
            options.put("type", this.getIssueType());
            if (!StringUtils.isEmpty((String)this.getIssuePriority())) {
                options.put("priority", this.getIssuePriority());
            }
            if (!StringUtils.isEmpty((String)(description = this.getIssueDescription()))) {
                options.put("description", description);
            }
            if (!StringUtils.isEmpty((String)(assignee = this.getAssignee()))) {
                options.put("assignee", assignee);
            }
            RemoteIssue issue = client.createIssue(options);
            this.getIssueActions().put(issue.getKey(), "created");
            Context.getLogger().info("The issue [" + issue.getKey() + "] created successfully.");
            this.onAfterRun();
        }
        finally {
            if (client != null) {
                client.logout();
            }
        }
    }

    public Class<? extends AbstractTrackerPlugin> getPluginClass() {
        return JiraPlugin.class;
    }
}

