/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.setting;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.tracker.core.setting.AbstractTrackerSetting;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.jira.JiraPlugin;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;
import org.swift.common.soap.jira.RemoteVersion;

@Editable(name="JIRA Server", order=1000, category={"Issue Tracker"})
public class JiraSetting
extends AbstractTrackerSetting {
    private static final long serialVersionUID = 1L;
    private String associatedProject;
    private String displayColumns;

    public JiraSetting() {
        this.setIssuePattern("([A-Z][A-Z]+)-\\d+");
    }

    public JiraSetting(String host, String user, String password) {
        this.setHost(StringHelper.normalizeUrl((String)host));
        this.setUser(user);
        this.setPassword(password);
    }

    public static JiraSetting get(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        return (JiraSetting)((Object)PluginSettingHelper.findConfigurationSetting(JiraPlugin.class, (Configuration)configuration, (boolean)true));
    }

    @Editable(order=1000, name="Associated Project Key", description="Specify key of the JIRA project this configuration corresponds to. This property will be used when:<ul class='square'><li>Use first unreleased version in JIRA as build version.</li><li>Release current build version into JIRA.</li><li>Associate issues with released versions via 'fix version/s' field.</li></ul>")
    @Scriptable
    @NotEmpty
    @ScriptApi
    public String getAssociatedProject() {
        return this.associatedProject;
    }

    public void setAssociatedProject(String associatedProject) {
        this.associatedProject = associatedProject;
    }

    @Editable(order=200, name="Server Url", description="Define the Jira server url. For example: http://jira.example.com")
    @NotEmpty
    @Scriptable
    @ScriptApi
    public String getHost() {
        return super.getHost();
    }

    @Editable(order=500, name="Issue Pattern", description="Specify <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">pattern</a> of JIRA issue keys in SCM commit message. This pattern will be used by QuickBuild to transform issue keys into issue links, and can normally be determined by suffixing the <a target=\"_blank\" href=\"http://confluence.atlassian.com/display/JIRA/Configuring+Project+Keys\">JIRA project key pattern</a> with <i>-\\d+</i>. For example, if the JIRA project key pattern is defined as ([A-Z]{2}[0-9]{2}), the issue pattern can then be specified as <i>([A-Z]{2}[0-9]{2})-\\d+</i>. If default pattern is used, <i>A-123</i> and <i>AB123</i> will not be recognized as issue keys, while <i>AB-123</i> will.<br><b>NOTE:</b> Word boundary (\\b) will be automatically added before and after this specified issue pattern when matching issue keys.")
    @NotEmpty
    @Scriptable
    @ScriptApi
    public String getIssuePattern() {
        return super.getIssuePattern();
    }

    @Editable(order=1200, name="Columns on Issue tab", description="Specify which columns you want to display on issue tab. Leave empty to use default. Comma to separate columns, for example, <code>Key, Summary, Issue Type, Resolution</code>Valid columns including: Key, Summary, Issue Type, Status, Priority, Resolution, Assignee, Reporter, Modifications.You may also use custom field name or id to display custom field column.")
    public String getDisplayColumns() {
        return this.displayColumns;
    }

    public void setDisplayColumns(String displayColumns) {
        this.displayColumns = displayColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getUnreleasedVersions(String projectKey, String pattern) {
        ArrayList<String> unreleased = new ArrayList<String>();
        JiraClient client = null;
        try {
            client = JiraClient.newInstance();
            RemoteVersion[] versions = client.getVersions(projectKey);
            Pattern pVersion = null;
            if (!StringUtils.isEmpty((String)pattern)) {
                pVersion = Pattern.compile(pattern);
            }
            for (RemoteVersion each : versions) {
                if (each.isReleased()) continue;
                if (pVersion == null) {
                    unreleased.add(each.getName());
                    continue;
                }
                Matcher m = pVersion.matcher(each.getName());
                if (!m.find()) continue;
                unreleased.add(each.getName());
            }
            ArrayList<String> arrayList = unreleased;
            return arrayList;
        }
        finally {
            JiraClient.closeQuietly(client);
        }
    }

    @ScriptApi(value="Get unreleased versions of associated project from JIRA.")
    public List<String> getUnreleasedVersions() {
        return JiraSetting.getUnreleasedVersions(this.getAssociatedProject(), null);
    }

    @ScriptApi(value="Use <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">Java regular expression</a> tomatch the unreleased versions of associated project from JIRA.")
    public List<String> getUnreleasedVersions(String versionPattern) {
        return JiraSetting.getUnreleasedVersions(this.getAssociatedProject(), versionPattern);
    }

    @ScriptApi(value="Get next unreleased version of associated project from JIRA.")
    public String getNextUnreleasedVersion() {
        return this.getNextUnreleasedVersion(null);
    }

    @ScriptApi(value="Use <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">Java regular expression</a> to match next unreleased version of associated project from JIRA.")
    public String getNextUnreleasedVersion(String versionPattern) {
        List<String> unreleased = this.getUnreleasedVersions(versionPattern);
        if (unreleased.isEmpty()) {
            throw new QuickbuildException("Unable to find any unreleased version matching specified pattern. You may need define at least one unreleased version in your JIRA instance.");
        }
        return unreleased.get(0);
    }
}

