/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.renderer;

import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.renderer.toolbar.AbstractLinkIssuePanel;
import com.pmease.quickbuild.plugin.tracker.core.renderer.toolbar.AbstractLinkIssueToolbar;
import com.pmease.quickbuild.plugin.tracker.jira.JiraIssue;
import com.pmease.quickbuild.plugin.tracker.jira.JiraTracker;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.plugin.tracker.jira.renderer.JiraReportPanel;
import com.pmease.quickbuild.plugin.tracker.jira.renderer.LinkIssueToolbar;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.swift.common.soap.jira.AbstractRemoteConstant;
import org.swift.common.soap.jira.RemoteFilter;
import org.swift.common.soap.jira.RemoteIssue;

public class LinkIssuePanel
extends AbstractLinkIssuePanel {
    private static final long serialVersionUID = 1L;
    private static final String FROM_FILTER = "JIRA Filter";
    private static final String FROM_LIST = "Specified Issue Keys";
    private String issuesFrom = "JIRA Filter";
    private String filter;
    private String list;
    private final Form<Void> form;
    protected int added = 0;
    protected List<Issue> issues = new ArrayList<Issue>();

    public LinkIssuePanel(String id, LinkIssueToolbar toolbar) {
        super(id, (AbstractLinkIssueToolbar)toolbar);
        this.form = new Form("linkIssuesForm");
        this.form.setOutputMarkupId(true);
        this.add(new Component[]{this.form});
        FeedbackPanel feedback = new FeedbackPanel("feedback", (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(this.form));
        feedback.setEscapeModelStrings(false);
        this.form.add(new Component[]{feedback});
        DropDownChoice choice = new DropDownChoice("fromType", (IModel)new PropertyModel((Object)this, "issuesFrom"), Arrays.asList(FROM_FILTER, FROM_LIST));
        choice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{LinkIssuePanel.this.form});
            }
        }});
        this.form.add(new Component[]{choice});
        DropDownChoice<String> filterChoice = new DropDownChoice<String>("filters", (IModel)new PropertyModel((Object)this, "filter"), this.getFilters()){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(LinkIssuePanel.this.issuesFrom.equalsIgnoreCase(LinkIssuePanel.FROM_FILTER));
            }
        };
        filterChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                LinkIssuePanel.this.updateIssueListFromFilter();
                StringBuffer sb = new StringBuffer();
                for (Issue each : LinkIssuePanel.this.issues) {
                    sb.append(each.getIssueKey()).append(" ");
                }
                LinkIssuePanel.this.list = sb.toString();
                target.add(new Component[]{LinkIssuePanel.this.form});
            }
        }});
        this.form.add(new Component[]{filterChoice});
        this.form.add(new Component[]{new Label("issueListLabel", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                if (LinkIssuePanel.FROM_FILTER.equalsIgnoreCase(LinkIssuePanel.this.issuesFrom)) {
                    return "Review issues below to be linked:";
                }
                return "Input issue keys below (space to separate):";
            }
        })});
        TextArea<String> textarea = new TextArea<String>("list", (IModel)new PropertyModel((Object)this, "list")){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(LinkIssuePanel.this.issuesFrom.equalsIgnoreCase(LinkIssuePanel.FROM_LIST) || !StringUtils.isEmpty((String)LinkIssuePanel.this.filter));
            }
        };
        this.form.add(new Component[]{textarea});
        AjaxButton submitBtn = new AjaxButton("submit", this.form){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                boolean succeed = LinkIssuePanel.this.updateFromList();
                if (!succeed) {
                    target.add(new Component[]{form});
                } else {
                    LinkIssuePanel.this.onAfterSubmit(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        };
        this.form.add(new Component[]{submitBtn});
        this.form.setDefaultButton((IFormSubmittingComponent)submitBtn);
        this.form.add(new Component[]{new AjaxLink<Void>("cancelButton"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                LinkIssuePanel.this.onAfterCancel(target);
            }
        }});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateIssueListFromFilter() {
        if (StringUtils.isEmpty((String)this.filter)) {
            this.issues = Collections.emptyList();
            return true;
        }
        JiraClient client = null;
        try {
            client = JiraClient.newInstance();
            RemoteIssue[] remoteIssues = client.getIssuesFromFilter(this.filter);
            ArrayList<Issue> issues = new ArrayList<Issue>();
            JiraReportPanel panel = (JiraReportPanel)this.dataGrid.getReportPanel();
            for (RemoteIssue each : remoteIssues) {
                JiraIssue issue = new JiraIssue(each);
                AbstractRemoteConstant c = panel.getRemoteConstant("status", issue.getStatus());
                if (c != null) {
                    issue.setStatus(c.getName());
                }
                if ((c = panel.getRemoteConstant("issueType", issue.getIssueType())) != null) {
                    issue.setIssueType(c.getName());
                }
                if ((c = panel.getRemoteConstant("priority", issue.getPriority())) != null) {
                    issue.setPriority(c.getName());
                }
                if ((c = panel.getRemoteConstant("resolution", issue.getResolution())) != null) {
                    issue.setResolution(c.getName());
                }
                issues.add(issue);
            }
            this.issues = issues;
            boolean bl = true;
            return bl;
        }
        catch (TrackerException e) {
            this.form.error((Serializable)((Object)e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            JiraClient.closeQuietly(client);
        }
    }

    private boolean updateFromList() {
        if (StringUtils.isEmpty((String)this.list)) {
            this.issues = new ArrayList<Issue>();
            return true;
        }
        String[] keys = StringUtils.split((String)this.list);
        JiraTracker tracker = new JiraTracker();
        try {
            Map<String, Issue> issues = tracker.fetchIssues(Arrays.asList(keys));
            this.issues = new ArrayList<Issue>(issues.values());
            return true;
        }
        catch (TrackerException e) {
            this.form.error((Serializable)((Object)e.getMessage()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getFilters() {
        JiraClient client = null;
        try {
            client = JiraClient.newInstance();
            RemoteFilter[] filters = client.getSavedFilters();
            ArrayList<String> result = new ArrayList<String>();
            for (RemoteFilter f : filters) {
                result.add(f.getName());
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (TrackerException e) {
            this.form.error((Serializable)((Object)("Please fix the errors: " + e.getMessage())));
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            JiraClient.closeQuietly(client);
        }
    }

    public String getIssuesFrom() {
        return this.issuesFrom;
    }

    public void setIssuesFrom(String issuesFrom) {
        this.issuesFrom = issuesFrom;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getList() {
        return this.list;
    }

    public void setList(String list) {
        this.list = list;
    }

    protected List<Issue> getIssues() {
        return this.issues;
    }
}

