/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.renderer;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStats;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.renderer.AbstractIssueRenderer;
import com.pmease.quickbuild.plugin.tracker.core.renderer.IssueReportPanel;
import com.pmease.quickbuild.plugin.tracker.jira.JiraTracker;
import com.pmease.quickbuild.plugin.tracker.jira.client.JiraClient;
import com.pmease.quickbuild.plugin.tracker.jira.renderer.JiraCustomFieldColumn;
import com.pmease.quickbuild.plugin.tracker.jira.renderer.LinkIssueToolbar;
import com.pmease.quickbuild.plugin.tracker.jira.setting.JiraSetting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.model.IModel;
import org.swift.common.soap.jira.AbstractNamedRemoteEntity;
import org.swift.common.soap.jira.AbstractRemoteConstant;
import org.swift.common.soap.jira.RemoteField;
import org.swift.common.soap.jira.RemoteIssueType;
import org.swift.common.soap.jira.RemotePriority;
import org.swift.common.soap.jira.RemoteResolution;
import org.swift.common.soap.jira.RemoteStatus;

public class JiraReportPanel
extends IssueReportPanel {
    private static final long serialVersionUID = 1L;
    RemotePriority[] priorities;
    RemoteStatus[] statuses;
    RemoteResolution[] resolutions;
    RemoteIssueType[] types;
    boolean connectionFailed = false;
    RemoteField[] customFields;

    public JiraReportPanel(String id, AbstractIssueRenderer renderer, IModel<RendererContext> contextModel) {
        super(id, (TableRenderer)renderer, contextModel);
    }

    public void onInitialize() {
        super.onInitialize();
        ReportStats stats = this.getReportStats();
        if (stats != null && MapUtils.getIntValue((Map)stats.getStats(), (Object)"TOTALS", (int)0) > 0) {
            this.initConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnections() {
        if (!this.isShowReports()) {
            return;
        }
        JiraClient client = null;
        try {
            client = JiraClient.newInstance();
            this.priorities = client.getPriorities();
            this.statuses = client.getStatuses();
            this.resolutions = client.getResolutions();
            this.types = client.getIssueTypes();
        }
        catch (TrackerException e) {
            this.connectionFailed = true;
            this.dataGrid.error((Serializable)((Object)("Connect to JIRA server failed due to: " + e.getMessage())));
        }
        finally {
            JiraClient.closeQuietly(client);
        }
    }

    protected void addToolbars(DataGrid dataGrid) {
        dataGrid.addTopToolbar((AbstractToolbar)new LinkIssueToolbar(dataGrid, ""));
        super.addToolbars(dataGrid);
    }

    public RemotePriority[] getPriorities() {
        return this.priorities;
    }

    public void setPriorities(RemotePriority[] priorities) {
        this.priorities = priorities;
    }

    public RemoteStatus[] getStatuses() {
        return this.statuses;
    }

    public void setStatuses(RemoteStatus[] statuses) {
        this.statuses = statuses;
    }

    public RemoteResolution[] getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(RemoteResolution[] resolutions) {
        this.resolutions = resolutions;
    }

    public RemoteIssueType[] getTypes() {
        return this.types;
    }

    public void setTypes(RemoteIssueType[] types) {
        this.types = types;
    }

    public AbstractRemoteConstant getRemoteConstant(String type, String value) {
        RemoteType remoteType = RemoteType.valueOf(type.toUpperCase());
        switch (remoteType) {
            case ISSUETYPE: {
                return (AbstractRemoteConstant)JiraClient.getRemoteEntity(value, (AbstractNamedRemoteEntity[])this.types);
            }
            case PRIORITY: {
                return (AbstractRemoteConstant)JiraClient.getRemoteEntity(value, (AbstractNamedRemoteEntity[])this.priorities);
            }
            case STATUS: {
                return (AbstractRemoteConstant)JiraClient.getRemoteEntity(value, (AbstractNamedRemoteEntity[])this.statuses);
            }
            case RESOLUTION: {
                return (AbstractRemoteConstant)JiraClient.getRemoteEntity(value, (AbstractNamedRemoteEntity[])this.resolutions);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Issue> fetchIssues(List<String> ids) {
        JiraTracker tracker = new JiraTracker();
        JiraClient client = null;
        try {
            client = JiraClient.newInstance();
            Map<String, Issue> map = tracker.fetchIssues(client, ids, this.priorities, this.statuses, this.resolutions, this.types);
            return map;
        }
        finally {
            JiraClient.closeQuietly(client);
        }
    }

    RemoteField findCustomField(String name) {
        for (RemoteField each : this.customFields) {
            if (!name.equalsIgnoreCase(each.getId()) && !name.equalsIgnoreCase(each.getName())) continue;
            return each;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<TableColumn> getTableColumns() {
        JiraClient client = null;
        try {
            client = JiraClient.newInstance();
            this.customFields = client.getCustomFields();
        }
        catch (TrackerException e) {
            this.customFields = new RemoteField[0];
        }
        finally {
            JiraClient.closeQuietly(client);
        }
        ArrayList list = Lists.newArrayList();
        JiraSetting setting = JiraSetting.get(Context.getConfiguration());
        String str = setting.getDisplayColumns();
        if (Strings.isNullOrEmpty((String)str)) {
            return super.getTableColumns();
        }
        ArrayList names = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)str));
        ArrayList columns = Lists.newArrayList((Iterable)this.getRenderer().getColumns());
        for (String each : names) {
            if (each.equalsIgnoreCase("fixVersions")) {
                list.add(new JiraCustomFieldColumn((AbstractRenderer)this.getRenderer(), "fixVersions", "Fix Version/s"));
                continue;
            }
            if (each.equalsIgnoreCase("affectsVersions")) {
                list.add(new JiraCustomFieldColumn((AbstractRenderer)this.getRenderer(), "affectsVersions", "Affected Version/s"));
                continue;
            }
            if ("components".equalsIgnoreCase(each)) {
                list.add(new JiraCustomFieldColumn((AbstractRenderer)this.getRenderer(), "components", "Components"));
                continue;
            }
            if ("created".equalsIgnoreCase(each)) {
                list.add(new JiraCustomFieldColumn((AbstractRenderer)this.getRenderer(), "created", "Created On"));
                continue;
            }
            if ("duedate".equalsIgnoreCase(each)) {
                list.add(new JiraCustomFieldColumn((AbstractRenderer)this.getRenderer(), "duedate", "Due Date"));
                continue;
            }
            if ("updated".equalsIgnoreCase(each)) {
                list.add(new JiraCustomFieldColumn((AbstractRenderer)this.getRenderer(), "updated", "Updated On"));
                continue;
            }
            RemoteField f = this.findCustomField(each);
            if (f != null) {
                list.add(new JiraCustomFieldColumn((AbstractRenderer)this.getRenderer(), f.getId(), f.getName()));
                continue;
            }
            TableColumn t = JiraReportPanel.findColumn(each, columns);
            if (t != null) {
                list.add(t);
                continue;
            }
            Context.getLogger().warn("Column " + each + " not found");
        }
        return list;
    }

    private static TableColumn findColumn(String name, List<TableColumn> columns) {
        for (TableColumn c : columns) {
            if (c.getTitle().equalsIgnoreCase(name)) {
                return c;
            }
            if (!c.getKey().equalsIgnoreCase(name)) continue;
            return c;
        }
        return null;
    }

    protected JiraTracker getTracker() {
        return new JiraTracker();
    }

    protected boolean isConnectionFailed() {
        return this.connectionFailed;
    }

    public static enum RemoteType {
        ISSUETYPE,
        PRIORITY,
        STATUS,
        RESOLUTION;

    }
}

