/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.renderer;

import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.ImageItem;
import com.pmease.quickbuild.plugin.tracker.jira.renderer.JiraReportPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.swift.common.soap.jira.AbstractRemoteConstant;

public class JiraImageItem
extends ImageItem {
    private static final long serialVersionUID = 1L;

    public JiraImageItem(AbstractRenderer renderer) {
        super(renderer);
    }

    public Component createComponent(String id, IModel<ItemContext> model) {
        ItemContext context = (ItemContext)model.getObject();
        JiraReportPanel panel = (JiraReportPanel)context.getReportPanel();
        String value = this.getText(context);
        String field = this.getValueExpression();
        if (panel.isConnectionFailed()) {
            return new Label(id, value);
        }
        JiraReportPanel.RemoteType type = JiraReportPanel.RemoteType.valueOf(field.toUpperCase());
        String text = "";
        AbstractRemoteConstant remoteField = panel.getRemoteConstant(field, value);
        if (type == JiraReportPanel.RemoteType.RESOLUTION) {
            String css = "";
            if (remoteField == null) {
                text = "UNRESOLVED";
                css = "unresolved";
            } else {
                text = remoteField.getName();
            }
            text = "<span class=\"resolution " + css + "\">" + text + "</span>";
        } else {
            text = remoteField == null ? value : "<img src=\"" + remoteField.getIcon() + "\" title=\"" + remoteField.getName() + "\" />";
        }
        if (type == JiraReportPanel.RemoteType.STATUS && remoteField != null) {
            text = text + " " + remoteField.getName();
        }
        return new Label(id, text).setEscapeModelStrings(false);
    }

    public String getCss() {
        return "aleft";
    }
}

