/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.renderer;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import com.pmease.quickbuild.plugin.tracker.core.renderer.IssueReportPanel;
import com.pmease.quickbuild.plugin.tracker.jira.JiraIssue;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.swift.common.soap.jira.RemoteComponent;
import org.swift.common.soap.jira.RemoteCustomFieldValue;
import org.swift.common.soap.jira.RemoteVersion;

public class JiraCustomFieldColumn
extends TableColumn {
    private static final long serialVersionUID = 1L;
    private final String fieldId;
    private final String title;

    public JiraCustomFieldColumn(AbstractRenderer renderer, String id, String title) {
        super(renderer);
        this.fieldId = id;
        this.title = title;
    }

    static String formatRemoteVersions(RemoteVersion[] versions) {
        ArrayList list = Lists.newArrayList();
        for (RemoteVersion each : versions) {
            list.add(each.getName());
        }
        return Joiner.on((String)", ").skipNulls().join((Iterable)list);
    }

    public Component createComponent(String id, IModel<ItemContext> model) {
        String label;
        ItemContext context = (ItemContext)model.getObject();
        JiraIssue issue = (JiraIssue)((Object)context.get(IssueReportPanel.ISSUE_CONTEXT_KEY));
        if ("fixVersions".equalsIgnoreCase(this.fieldId)) {
            RemoteVersion[] versions = issue.getRemoteIssue().getFixVersions();
            label = JiraCustomFieldColumn.formatRemoteVersions(versions);
        } else if ("affectsVersions".equalsIgnoreCase(this.fieldId)) {
            label = JiraCustomFieldColumn.formatRemoteVersions(issue.getRemoteIssue().getAffectsVersions());
        } else if ("environment".equalsIgnoreCase(this.fieldId)) {
            label = issue.getRemoteIssue().getEnvironment();
        } else if ("components".equalsIgnoreCase(this.fieldId)) {
            RemoteComponent[] c = issue.getRemoteIssue().getComponents();
            ArrayList list = Lists.newArrayList();
            for (RemoteComponent each : c) {
                list.add(each.getName());
            }
            label = Joiner.on((String)", ").skipNulls().join((Iterable)list);
        } else if ("created".equalsIgnoreCase(this.fieldId)) {
            label = DataTypes.DATE.asString((Object)issue.getCreated());
        } else if ("duedate".equalsIgnoreCase(this.fieldId)) {
            label = DataTypes.DATE.asString((Object)issue.getRemoteIssue().getDuedate());
        } else if ("updated".equalsIgnoreCase(this.fieldId)) {
            label = DataTypes.DATE.asString((Object)issue.getRemoteIssue().getUpdated());
        } else {
            RemoteCustomFieldValue[] values = issue.getCustomValues();
            RemoteCustomFieldValue found = null;
            for (RemoteCustomFieldValue each : values) {
                if (!this.fieldId.equalsIgnoreCase(each.getKey()) && !this.fieldId.equalsIgnoreCase(each.getCustomfieldId())) continue;
                found = each;
                break;
            }
            label = found == null ? "" : Joiner.on((String)"\n").skipNulls().join((Object[])found.getValues());
        }
        return new Label(id, label);
    }

    public String getTitle() {
        return this.title;
    }

    public String getCss() {
        return "aleft";
    }
}

