/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.gadget;

import com.google.common.collect.Iterables;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.provider.ReportDataProvider;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.SearchNavToolbar;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import com.pmease.quickbuild.plugin.tracker.core.renderer.IssueDataGrid;
import com.pmease.quickbuild.plugin.tracker.jira.gadget.JiraGadget;
import com.pmease.quickbuild.plugin.tracker.jira.renderer.JiraRenderer;
import com.pmease.quickbuild.plugin.tracker.jira.renderer.JiraReportPanel;
import java.util.List;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class JiraGadgetRenderer
extends JiraRenderer {
    private static final long serialVersionUID = 1L;
    private final JiraGadget gadget;

    public JiraGadgetRenderer(ReportCategory category, JiraGadget gadget) {
        super(category);
        this.setMode(RendererMode.BUILD);
        ReportDataSource rds = this.getDataSource();
        rds.setOrderBy("buildId, created");
        rds.setAsc("false, false");
        this.setContentOnly(true);
        this.setCss("jira-table");
        if (gadget.getDisplayedBuilds() > 1) {
            this.setMode(RendererMode.STATISTICS);
        }
        this.gadget = gadget;
    }

    @Override
    public Panel createReportPanel(String id, IModel<RendererContext> model) {
        return new JiraReportPanel(id, this, model){
            private static final long serialVersionUID = 1L;

            protected IColumn<ItemContext> createOpColumn() {
                return null;
            }

            protected DataGrid newDataGrid(String id) {
                return new GadgetIssueDataGrid(id, this.getColumns(), this.getProvider(), (TableReportPanel)this);
            }

            public List<Filter> getFilters() {
                List filters = super.getFilters();
                int count = JiraGadgetRenderer.this.gadget.getDisplayedBuilds();
                if (count > 1) {
                    List builds = BuildUtils.getPreviousBuildsUntil((Build)Context.getBuild(), (int)count);
                    Build first = (Build)Iterables.getFirst((Iterable)builds, (Object)Context.getBuild());
                    Build last = (Build)Iterables.getLast((Iterable)builds, (Object)Context.getBuild());
                    filters.add(Restrictions.and((Filter)Restrictions.ge((String)"buildId", (Object)last.getId()), (Filter)Restrictions.le((String)"buildId", (Object)first.getId())));
                }
                return filters;
            }

            @Override
            protected void addToolbars(DataGrid dataGrid) {
                super.addDefaultToolbars(dataGrid);
                dataGrid.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar((DataTable)dataGrid, (ISortStateLocator)dataGrid.getProvider()));
                dataGrid.addBottomToolbar((AbstractToolbar)new SearchNavToolbar.NavBar(dataGrid, Integer.valueOf(JiraGadgetRenderer.this.gadget.getRowsPerPage()).intValue()));
            }
        };
    }

    private class GadgetIssueDataGrid
    extends IssueDataGrid {
        private static final long serialVersionUID = 1L;

        public GadgetIssueDataGrid(String id, List<IColumn<ItemContext>> columns, ReportDataProvider dataProvider, TableReportPanel parentPanel) {
            super(id, columns, dataProvider, parentPanel);
        }

        protected boolean isGroupable() {
            return JiraGadgetRenderer.this.gadget.getDisplayedBuilds() > 1;
        }
    }
}

