/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.gadget;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.tracker.core.gadget.AbstractIssueGadget;
import com.pmease.quickbuild.plugin.tracker.jira.JiraPlugin;
import com.pmease.quickbuild.plugin.tracker.jira.gadget.JiraGadgetRenderer;
import com.pmease.quickbuild.plugin.tracker.jira.setting.JiraSetting;
import java.util.List;

@Editable(name="JIRA Issues", category={"Changes and Issues"})
public class JiraGadget
extends AbstractIssueGadget {
    private static final long serialVersionUID = 1L;
    private int displayedBuilds = 1;

    protected void checkPermission() {
        super.checkPermission();
        if (JiraSetting.get(Context.getConfiguration()) == null) {
            throw new QuickbuildException("No JIRA setting defined for the configuration: " + Context.getConfiguration().getPathName());
        }
    }

    private static List<String> getAvailableColumns() {
        return Lists.newArrayList((Object[])new String[]{"Key", "Summary", "Issue Type", "Status", "Priority", "Resolution", "Assignee", "Reporter", "Modifications"});
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(JiraPlugin.class);
    }

    protected TableRenderer createGadgetRenderer() {
        return new JiraGadgetRenderer(this.getCategory(), this);
    }

    @Editable(name="Builds Displayed", description="How many builds to be displayed. By default, only the build selected will be displayed")
    public int getDisplayedBuilds() {
        return this.displayedBuilds;
    }

    public void setDisplayedBuilds(int displayedBuilds) {
        this.displayedBuilds = displayedBuilds;
    }
}

