/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.jira.client;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommitCommand;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.jira.setting.JiraSetting;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.rpc.ServiceException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.common.soap.jira.AbstractNamedRemoteEntity;
import org.swift.common.soap.jira.JiraSoapService;
import org.swift.common.soap.jira.JiraSoapServiceServiceLocator;
import org.swift.common.soap.jira.RemoteAuthenticationException;
import org.swift.common.soap.jira.RemoteComment;
import org.swift.common.soap.jira.RemoteComponent;
import org.swift.common.soap.jira.RemoteCustomFieldValue;
import org.swift.common.soap.jira.RemoteField;
import org.swift.common.soap.jira.RemoteFieldValue;
import org.swift.common.soap.jira.RemoteFilter;
import org.swift.common.soap.jira.RemoteIssue;
import org.swift.common.soap.jira.RemoteIssueType;
import org.swift.common.soap.jira.RemoteNamedObject;
import org.swift.common.soap.jira.RemotePermissionException;
import org.swift.common.soap.jira.RemotePermissionScheme;
import org.swift.common.soap.jira.RemotePriority;
import org.swift.common.soap.jira.RemoteProject;
import org.swift.common.soap.jira.RemoteResolution;
import org.swift.common.soap.jira.RemoteScheme;
import org.swift.common.soap.jira.RemoteStatus;
import org.swift.common.soap.jira.RemoteUser;
import org.swift.common.soap.jira.RemoteValidationException;
import org.swift.common.soap.jira.RemoteVersion;
import org.swift.common.soap.jira.RemoteWorklog;

public class JiraClient {
    private static final Logger logger = LoggerFactory.getLogger(JiraClient.class);
    protected JiraSoapService service;
    protected long loginTime = Long.MAX_VALUE;
    protected int TIME_OUT_LIMIT = 1200000;
    protected String token;
    protected String serverUrl;
    protected String user;
    protected String password;
    private RemoteIssueType[] issueTypes = new RemoteIssueType[0];
    static Pattern pWorklog = Pattern.compile("^((\\d+w\\s+)?(\\d+d\\s+)?(\\d+h\\s+)?(\\d+m\\s+)?)");
    private static final Set<String> CLOSED_STATUS = ImmutableSet.of((Object)"5", (Object)"6", (Object)"10000");

    public JiraClient() {
    }

    public JiraClient(JiraSetting server) {
        this.serverUrl = StringHelper.normalizeUrl((String)server.getHost());
        this.user = server.getUser();
        this.password = server.getPassword();
    }

    public JiraClient(String serverUrl, String user, String password) {
        this.serverUrl = serverUrl;
        this.user = user;
        this.password = password;
    }

    public static JiraClient newInstance() {
        JiraSetting server = JiraSetting.get(Context.getConfiguration());
        if (server == null) {
            throw new QuickbuildException("Current configuration has no Jira setting or the setting is not configured properly.");
        }
        JiraClient client = new JiraClient(server);
        client.setupRemote();
        return client;
    }

    public static void closeQuietly(JiraClient client) {
        if (client != null) {
            client.logout();
        }
    }

    public static Set<String> supportedCommands() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String each : Action.availableCommands()) {
            result.add(each);
        }
        return result;
    }

    public void handleCommand(CommitCommand command) {
        Action action = Action.fromCommand(command.getAction().toLowerCase());
        switch (action) {
            case CREATEISSUE: {
                this.createIssue(command.getOptions());
                break;
            }
            case CREATEPROJECT: {
                this.createProject(command.getOptions());
                break;
            }
            case UPDATEISSUE: {
                this.updateIssue(command.getIssue(), command.getOptions());
                break;
            }
            default: {
                throw new IllegalArgumentException("The action " + action.name().toLowerCase() + " is not supported.");
            }
        }
    }

    protected String getDefaultServiceExtension() {
        return "/rpc/soap/jirasoapservice-v2";
    }

    protected boolean isTokenValid() {
        return this.service != null && this.token != null && System.currentTimeMillis() - this.loginTime < (long)this.TIME_OUT_LIMIT;
    }

    public void login() {
        if (logger.isDebugEnabled()) {
            logger.debug("Login to Jira server " + this.serverUrl);
        }
        JiraSoapServiceServiceLocator serviceLocator = new JiraSoapServiceServiceLocator();
        serviceLocator.setJirasoapserviceV2EndpointAddress(this.serverUrl + this.getDefaultServiceExtension());
        try {
            this.service = serviceLocator.getJirasoapserviceV2();
            if (!this.isTokenValid()) {
                this.token = this.service.login(this.user, this.password);
                this.loginTime = System.currentTimeMillis();
            }
        }
        catch (ServiceException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public void logout() {
        if (logger.isDebugEnabled()) {
            logger.debug("Logout Jira server " + this.serverUrl);
        }
        if (this.service == null) {
            return;
        }
        try {
            this.service.logout(this.token);
            this.service = null;
            this.token = null;
            this.loginTime = 0L;
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public void setupRemote() {
        if (this.isTokenValid()) {
            return;
        }
        this.login();
    }

    protected boolean isNoSuchOperation(Exception e) {
        String msg = e.getMessage();
        return msg.contains("No such operation");
    }

    protected RemoteProject findProject(String projectKey) {
        RemoteProject[] projects;
        for (RemoteProject each : projects = this.getAllProjects()) {
            if (!each.getKey().equalsIgnoreCase(projectKey)) continue;
            return each;
        }
        return null;
    }

    public RemoteProject[] getAllProjects() {
        try {
            RemoteProject[] projects = this.service.getProjectsNoSchemes(this.token);
            return projects;
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public String[] getAllProjectKeys() {
        RemoteProject[] projects = this.getAllProjects();
        String[] keys = new String[projects.length];
        for (int i = 0; i < projects.length; ++i) {
            keys[i] = projects[i].getKey();
        }
        return keys;
    }

    public RemoteProject getProject(String projectKey) {
        try {
            try {
                Long number = Long.valueOf(projectKey);
                return this.service.getProjectById(this.token, number.longValue());
            }
            catch (NumberFormatException e) {
                return this.service.getProjectByKey(this.token, projectKey);
            }
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            if (this.isNoSuchOperation(e)) {
                return this.findProject(projectKey);
            }
            throw new TrackerException((Throwable)e);
        }
    }

    public boolean hasProject(String projectKey) {
        try {
            return this.getProject(projectKey) != null;
        }
        catch (TrackerException e) {
            return false;
        }
    }

    protected String getString(Map<String, String> attributes, String name) {
        return attributes.get(name);
    }

    protected String getRequiredString(Map<String, String> attributes, String name) {
        String value = this.getString(attributes, name);
        if (StringUtils.isEmpty((String)value)) {
            throw new TrackerException("The required string [" + name + "] does not specified!");
        }
        return value;
    }

    public RemoteProject createProject(Map<String, String> attributes) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating project " + attributes.get("key"));
        }
        RemoteProject project = new RemoteProject();
        String key = this.getRequiredString(attributes, "key");
        String lead = this.getRequiredString(attributes, "lead");
        project.setKey(key.toUpperCase());
        project.setLead(lead);
        String name = this.getString(attributes, "name");
        if (StringUtils.isEmpty((String)name)) {
            name = key;
        }
        project.setName(name);
        project.setDescription(this.getString(attributes, "description"));
        String permissionScheme = this.getString(attributes, "permissionScheme");
        if (StringUtils.isEmpty((String)permissionScheme)) {
            RemotePermissionScheme defaultScheme = new RemotePermissionScheme();
            defaultScheme.setId(Long.valueOf(0L));
            project.setPermissionScheme(defaultScheme);
        } else {
            project.setPermissionScheme((RemotePermissionScheme)this.getScheme(permissionScheme, "Permission", true));
        }
        try {
            String notificationScheme;
            String securityScheme = this.getString(attributes, "issueSecurityScheme");
            if (!StringUtils.isEmpty((String)securityScheme)) {
                project.setIssueSecurityScheme(this.getScheme(securityScheme, "Issue Security", false));
            }
            if (!StringUtils.isEmpty((String)(notificationScheme = this.getString(attributes, "notificationScheme")))) {
                project.setNotificationScheme(this.getScheme(notificationScheme, "Notification", false));
            }
        }
        catch (TrackerException e) {
            // empty catch block
        }
        try {
            return this.service.createProjectFromObject(this.token, project);
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteValidationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public void deleteProject(String projectKey) {
        if (logger.isDebugEnabled()) {
            logger.debug("Deleting project " + projectKey);
        }
        if (this.hasProject(projectKey)) {
            try {
                this.service.deleteProject(this.token, projectKey);
            }
            catch (RemotePermissionException e) {
                throw new TrackerException((Throwable)e);
            }
            catch (RemoteAuthenticationException e) {
                throw new TrackerException((Throwable)e);
            }
            catch (org.swift.common.soap.jira.RemoteException e) {
                throw new TrackerException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new TrackerException((Throwable)e);
            }
        }
    }

    public RemoteIssue getIssue(String issueKey) {
        try {
            return this.service.getIssue(this.token, issueKey);
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public RemoteIssue getNullableIssue(String issueKey) {
        try {
            return this.getIssue(issueKey);
        }
        catch (TrackerException e) {
            return null;
        }
    }

    public RemoteIssue createIssue(Map<String, String> attributes) {
        String project = this.getRequiredString(attributes, "project");
        String type = this.getString(attributes, "type");
        String summary = this.getRequiredString(attributes, "summary");
        if (StringUtils.isEmpty((String)type)) {
            type = "Bug";
        }
        RemoteIssue issue = new RemoteIssue();
        issue.setProject(project);
        issue.setSummary(summary);
        issue.setType(this.getIssueType(type, project, false).getId());
        issue.setAssignee("-1");
        this.updateFromParameters(issue, null, attributes);
        if (StringUtils.isEmpty((String)issue.getReporter())) {
            issue.setReporter(this.user);
        }
        if (StringUtils.isEmpty((String)issue.getPriority())) {
            issue.setPriority("3");
        }
        try {
            issue = this.service.createIssue(this.token, issue);
            this.processExtraAttributes(issue.getKey(), attributes);
            return issue;
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteValidationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public RemoteFilter[] getSavedFilters() {
        try {
            return this.service.getSavedFilters(this.token);
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public RemoteIssue[] getIssuesFromFilter(String filter) {
        RemoteFilter[] filters = this.getSavedFilters();
        int index = JiraClient.findEntityIndex(filter, (AbstractNamedRemoteEntity[])filters);
        if (index < 0) {
            throw new TrackerException("Filter '" + filter + "' is not valid");
        }
        try {
            return this.service.getIssuesFromFilter(this.token, filters[index].getId());
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public RemoteIssue[] getIssuesFromJql(String search) {
        try {
            return this.service.getIssuesFromJqlSearch(this.token, search, Integer.MAX_VALUE);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public void updateIssue(String issueKey, Map<String, String> attributes) {
        RemoteIssue issue = this.getIssue(issueKey);
        HashSet<RemoteFieldValue> values = new HashSet<RemoteFieldValue>();
        this.updateFromParameters(issue, values, attributes);
        this.updateIssue(issueKey, values);
        this.processExtraAttributes(issueKey, attributes);
    }

    protected void updateIssue(String issueKey, Set<RemoteFieldValue> values) {
        if (values.size() > 0) {
            try {
                this.service.updateIssue(this.token, issueKey, values.toArray(new RemoteFieldValue[values.size()]));
            }
            catch (org.swift.common.soap.jira.RemoteException e) {
                throw new TrackerException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new TrackerException((Throwable)e);
            }
        } else {
            String message = "There are no field values changed by the parameters specified. Issue " + issueKey + " not changed.";
            logger.info(message);
        }
    }

    private RemoteFieldValue createSimpleField(String id, String value) {
        return new RemoteFieldValue(id, new String[]{value});
    }

    protected void updateFromParameters(RemoteIssue issue, Set<RemoteFieldValue> values, Map<String, String> attributes) {
        String commaSeparated;
        String value;
        String project = issue.getProject();
        if (attributes.containsKey("summary")) {
            value = this.getString(attributes, "summary");
            if (values == null) {
                issue.setSummary(value);
            } else if (!value.equals(issue.getSummary())) {
                values.add(this.createSimpleField("summary", value));
            }
        }
        if (attributes.containsKey("description")) {
            value = this.getString(attributes, "description");
            if (values == null) {
                issue.setDescription(value);
            } else if (!value.equals(issue.getDescription())) {
                values.add(this.createSimpleField("description", value));
            }
        }
        if (attributes.containsKey("type")) {
            value = this.getIssueType(this.getString(attributes, "type"), project).getId();
            if (values == null) {
                issue.setType(value);
            } else if (!value.equals(issue.getType())) {
                values.add(this.createSimpleField("issuetype", value));
            }
        }
        if (attributes.containsKey("priority")) {
            value = this.getPriority(this.getString(attributes, "priority")).getId();
            if (values == null) {
                issue.setPriority(value);
            } else if (!value.equals(issue.getPriority())) {
                values.add(this.createSimpleField("priority", value));
            }
        }
        if (attributes.containsKey("reporter")) {
            value = this.getString(attributes, "reporter");
            if (values == null) {
                issue.setReporter(value);
            } else if (!value.equals(issue.getReporter())) {
                values.add(this.createSimpleField("reporter", value));
            }
        }
        if (attributes.containsKey("resolution")) {
            value = this.getResolution(this.getString(attributes, "resolution")).getId();
            if (values == null) {
                issue.setResolution(value);
            } else if (!value.equals(issue.getResolution())) {
                values.add(this.createSimpleField("resolution", value));
            }
        }
        if (attributes.containsKey("assignee")) {
            value = this.getString(attributes, "assignee");
            if (values == null) {
                issue.setAssignee(value);
            } else if (!value.equals(issue.getAssignee())) {
                values.add(this.createSimpleField("assignee", value));
            }
        }
        if (attributes.containsKey("duedate")) {
            value = this.getString(attributes, "duedate");
            String dateFormat = this.getString(attributes, "dateFormat");
            if (StringUtils.isEmpty((String)dateFormat)) {
                dateFormat = "yyyy-MM-dd";
            }
            Calendar duedate = (Calendar)DataTypes.TIME.fromString(value, dateFormat);
            if (values == null) {
                issue.setDuedate(duedate);
            } else if (!value.equalsIgnoreCase(DataTypes.TIME.asString((Object)issue.getDuedate(), dateFormat))) {
                values.add(this.createSimpleField("duedate", value));
            }
        }
        if (attributes.containsKey("components")) {
            commaSeparated = this.getString(attributes, "components");
            this.updateComponents(commaSeparated, issue, values, project, false);
        }
        if (attributes.containsKey("environment")) {
            value = this.getString(attributes, "environment");
            if (values == null) {
                issue.setEnvironment(value);
            } else if (!value.equals(issue.getEnvironment())) {
                values.add(this.createSimpleField("environment", value));
            }
        }
        if (attributes.containsKey("affectsVersions")) {
            commaSeparated = this.getString(attributes, "affectsVersions");
            this.updateVersions(commaSeparated, "affectsVersions", issue, values, project);
        }
        if (attributes.containsKey("fixVersions")) {
            commaSeparated = this.getString(attributes, "fixVersions");
            this.updateVersions(commaSeparated, "fixVersions", issue, values, project);
        }
        this.updateCustomFields(issue, values, attributes);
    }

    public RemoteField[] getCustomFields() {
        try {
            return this.service.getCustomFields(this.token);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public RemoteField getCustomField(String id) {
        RemoteField[] fields;
        for (RemoteField each : fields = this.getCustomFields()) {
            if (!id.equalsIgnoreCase(each.getId()) && !id.equalsIgnoreCase(each.getName())) continue;
            return each;
        }
        return null;
    }

    static boolean isCustomField(String name) {
        if (name.startsWith("customfield_")) {
            return true;
        }
        try {
            Long.valueOf(name);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    static String getCustomFieldId(String key) {
        int pos = key.indexOf("customfield_");
        if (pos > 0) {
            return key;
        }
        try {
            Long.valueOf(key);
            return "customfield_" + key;
        }
        catch (NumberFormatException e) {
            throw new TrackerException("Custom field name is invalid! Please use either customfield_123 or 123 instead.");
        }
    }

    protected void updateCustomFields(RemoteIssue issue, Set<RemoteFieldValue> values, Map<String, String> attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        ArrayList<RemoteCustomFieldValue> customFields = new ArrayList<RemoteCustomFieldValue>();
        for (String each : attributes.keySet()) {
            if (!JiraClient.isCustomField(each)) continue;
            String value = this.getString(attributes, each);
            String fieldId = this.getRemoteFieldId(each);
            RemoteCustomFieldValue fieldValue = new RemoteCustomFieldValue();
            fieldValue.setCustomfieldId(fieldId);
            fieldValue.setValues(new String[]{value});
            customFields.add(fieldValue);
        }
        if (customFields.size() > 0) {
            if (values == null) {
                issue.setCustomFieldValues(customFields.toArray(new RemoteCustomFieldValue[customFields.size()]));
            } else {
                RemoteCustomFieldValue[] currentFields = issue.getCustomFieldValues();
                for (RemoteCustomFieldValue each : customFields) {
                    boolean matched = false;
                    for (RemoteCustomFieldValue current : currentFields) {
                        if (!JiraClient.isCustomeFieldEquals(each, current)) continue;
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    values.add(new RemoteFieldValue(each.getCustomfieldId(), each.getValues()));
                }
            }
        }
    }

    static boolean isCustomeFieldEquals(RemoteCustomFieldValue lhs, RemoteCustomFieldValue rhs) {
        return new EqualsBuilder().append((Object)lhs.getCustomfieldId(), (Object)rhs.getCustomfieldId()).append((Object[])lhs.getValues(), (Object[])rhs.getValues()).isEquals();
    }

    public void updateComponents(String commaSeparated, RemoteIssue issue, Set<RemoteFieldValue> values, String project, boolean forceUpdate) {
        String[] components = Strings.isNullOrEmpty((String)commaSeparated) ? new String[]{} : (String[])Iterables.toArray((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)commaSeparated), String.class);
        RemoteComponent[] remoteComponents = new RemoteComponent[components.length];
        Object[] ids = new String[components.length];
        boolean doValidation = true;
        for (int count = 1; count <= 2 && doValidation; ++count) {
            doValidation = false;
            for (int i = 0; i < components.length; ++i) {
                RemoteComponent[] list;
                String component = components[i].trim();
                int index = JiraClient.findEntityIndex(component, (AbstractNamedRemoteEntity[])(list = this.getComponents(project)));
                if (index < 0) {
                    throw new TrackerException("Component '" + components[i] + "' is not valid for project with key: " + project);
                }
                remoteComponents[i] = list[index];
                ids[i] = list[index].getId();
            }
        }
        if (values != null) {
            RemoteComponent[] currentComponents = issue.getComponents();
            Object[] currentIds = new String[currentComponents.length];
            for (int i = 0; i < currentComponents.length; ++i) {
                currentIds[i] = currentComponents[i].getId();
            }
            if (forceUpdate || !Objects.equal((Object)Sets.newHashSet((Object[])ids), (Object)Sets.newHashSet((Object[])currentIds))) {
                values.add(new RemoteFieldValue("components", (String[])ids));
            }
        } else {
            issue.setComponents(remoteComponents);
        }
    }

    public RemoteComponent[] getComponents(String project) {
        try {
            return this.service.getComponents(this.token, project);
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    protected void updateVersions(String commaSeparated, String parameter, RemoteIssue issue, Set<RemoteFieldValue> values, String project) {
        String[] versions = commaSeparated.equals("") ? new String[]{} : commaSeparated.split(",");
        RemoteVersion[] remoteVersions = new RemoteVersion[versions.length];
        String[] ids = new String[remoteVersions.length];
        boolean doValidation = true;
        for (int count = 1; count <= 2 && doValidation; ++count) {
            doValidation = false;
            RemoteVersion[] list = this.getVersions(project);
            for (int i = 0; i < versions.length; ++i) {
                String version = versions[i].trim();
                int index = JiraClient.findEntityIndex(version, (AbstractNamedRemoteEntity[])list);
                if (index >= 0) {
                    remoteVersions[i] = list[index];
                    ids[i] = list[index].getId();
                    continue;
                }
                this.addVersion(project, version, null, null);
            }
        }
        if (values != null) {
            ArrayList<RemoteVersion> currentVersions;
            if (parameter.equalsIgnoreCase("fixVersions")) {
                currentVersions = new ArrayList<RemoteVersion>(Arrays.asList(issue.getFixVersions()));
            } else if (parameter.equalsIgnoreCase("affectsVersions")) {
                currentVersions = new ArrayList<RemoteVersion>(Arrays.asList(issue.getAffectsVersions()));
            } else {
                throw new IllegalArgumentException("Program error - unexpected value of: " + parameter);
            }
            LinkedHashSet<String> currentIds = new LinkedHashSet<String>();
            for (RemoteVersion each : currentVersions) {
                currentIds.add(each.getId());
            }
            for (String id : ids) {
                if (currentIds.contains(id)) continue;
                currentIds.add(id);
            }
            if (parameter.equalsIgnoreCase("fixVersions")) {
                values.add(new RemoteFieldValue("fixVersions", currentIds.toArray(new String[currentIds.size()])));
            } else {
                values.add(new RemoteFieldValue("affectVersions", currentIds.toArray(new String[currentIds.size()])));
            }
        } else if (parameter.equalsIgnoreCase("fixVersions")) {
            issue.setFixVersions(remoteVersions);
        } else if (parameter.equals("affectsVersions")) {
            issue.setAffectsVersions(remoteVersions);
        }
    }

    public boolean addVersion(String project, String name, String after, Calendar releaseDate) {
        RemoteVersion afterVersion;
        RemoteVersion remoteVersion = new RemoteVersion();
        remoteVersion.setName(name);
        if (after != null && !after.equals("") && (afterVersion = this.getRemoteVersion(project, after, true)) != null) {
            remoteVersion.setSequence(afterVersion.getSequence());
        }
        if (releaseDate != null) {
            remoteVersion.setReleaseDate(releaseDate);
        }
        try {
            this.service.addVersion(this.token, project, remoteVersion);
            return true;
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public void addWorklog(String issueKey, String time) {
        CaseInsensitiveMap attributes = CaseInsensitiveMap.create();
        attributes.put("time", time);
        this.addWorklog(issueKey, (Map<String, String>)attributes);
    }

    public static String[] parseWorklogText(String text) {
        if (StringUtils.isBlank((String)text)) {
            return new String[0];
        }
        Matcher m = pWorklog.matcher(text.trim());
        if (!m.find()) {
            return new String[0];
        }
        int pos = m.end();
        String[] result = new String[]{text.substring(0, pos).trim(), pos < text.length() ? text.substring(pos) : ""};
        return result;
    }

    public void addWorklog(String issueKey, Map<String, String> attributes) {
        this.getIssue(issueKey);
        String text = this.getRequiredString(attributes, "time");
        String[] tokens = JiraClient.parseWorklogText(text);
        String time = tokens[0];
        String comment = tokens[1];
        RemoteWorklog log = new RemoteWorklog();
        log.setTimeSpent(time);
        if (!StringUtils.isEmpty((String)comment)) {
            log.setComment(comment);
        }
        log.setStartDate(Calendar.getInstance());
        try {
            this.service.addWorklogAndAutoAdjustRemainingEstimate(this.token, issueKey, log);
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteValidationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public void addComment(String issueKey, String comment) {
        this.addComment(issueKey, comment, "");
    }

    public void addComment(String issueKey, String comment, String author) {
        if (StringUtils.isEmpty((String)comment)) {
            return;
        }
        RemoteComment c = new RemoteComment();
        c.setBody(comment);
        if (StringUtils.isEmpty((String)author)) {
            c.setAuthor(this.user);
        } else {
            c.setAuthor(author);
        }
        try {
            this.service.addComment(this.token, issueKey, c);
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public void updateAssignee(String issueKey, String assignee) {
        CaseInsensitiveMap attributes = CaseInsensitiveMap.create();
        attributes.put("assignee", assignee);
        this.updateIssue(issueKey, (Map<String, String>)attributes);
    }

    public void progressWorkflow(String issueKey, Map<String, String> attributes) {
        try {
            RemoteIssue issue = this.getIssue(issueKey);
            String step = this.getRequiredString(attributes, "step");
            String stepId = this.getStepId(issueKey, step);
            HashSet<RemoteFieldValue> valueSet = new HashSet<RemoteFieldValue>();
            this.updateFromParameters(issue, valueSet, attributes);
            this.service.progressWorkflowAction(this.token, issueKey, stepId, valueSet.toArray(new RemoteFieldValue[valueSet.size()]));
            this.processExtraAttributes(issueKey, attributes);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    protected void processExtraAttributes(String issueKey, Map<String, String> attributes) {
        String attr = this.getString(attributes, "comment");
        if (!StringUtils.isEmpty((String)attr)) {
            this.addComment(issueKey, attr);
        }
        if (!StringUtils.isEmpty((String)(attr = this.getString(attributes, "time")))) {
            this.addWorklog(issueKey, attr);
        }
    }

    public String getStepId(String issueKey, String step) {
        try {
            RemoteNamedObject[] availableActions = this.service.getAvailableActions(this.token, issueKey);
            if (availableActions != null) {
                for (RemoteNamedObject action : availableActions) {
                    if (!action.getName().equalsIgnoreCase(step) && !action.getId().equals(step)) continue;
                    return action.getId();
                }
            }
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        throw new TrackerException("Workflow step '" + step + "' is not valid for issue: " + issueKey);
    }

    public RemoteVersion[] getVersions(String projectKey) {
        try {
            return this.service.getVersions(this.token, projectKey);
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public RemoteVersion getVersion(String projectKey, String version) {
        RemoteVersion[] versions;
        for (RemoteVersion v : versions = this.getVersions(projectKey)) {
            if (!v.getName().equals(version)) continue;
            return v;
        }
        return null;
    }

    public RemoteVersion createVersion(String projectKey, String version) {
        RemoteVersion v = new RemoteVersion();
        v.setName(version);
        try {
            return this.service.addVersion(this.token, projectKey, v);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public void releaseVersion(String projectKey, String version) {
        RemoteVersion v = this.getVersion(projectKey, version);
        if (v == null) {
            v = this.createVersion(projectKey, version);
        }
        if (!v.isReleased()) {
            v.setReleased(true);
            v.setReleaseDate(Calendar.getInstance());
            try {
                this.service.releaseVersion(this.token, projectKey, v);
            }
            catch (org.swift.common.soap.jira.RemoteException e) {
                throw new TrackerException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new TrackerException((Throwable)e);
            }
        }
    }

    public void updateFixVersions(String issueKey, String version) {
        this.updateFixVersions(issueKey, version, null);
    }

    public void updateFixVersions(String issueKey, String version, Map<String, String> attributes) {
        this.updateFixVersions(issueKey, version, CLOSED_STATUS, attributes);
    }

    public void updateFixVersions(String issueKey, String version, Set<String> acceptStatuses, Map<String, String> attributes) {
        RemoteIssue issue = this.getIssue(issueKey);
        String status = issue.getStatus();
        if (attributes == null) {
            attributes = CaseInsensitiveMap.create();
        }
        if (acceptStatuses.contains(status)) {
            attributes.put("fixVersions", version);
            this.updateIssue(issueKey, (Map<String, String>)attributes);
        }
    }

    public void archiveVersion(String projectKey, String version) {
        try {
            this.service.archiveVersion(this.token, projectKey, version, true);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public RemoteIssueType getIssueType(String value, String projectKey) {
        try {
            return this.getIssueType(value, projectKey, true);
        }
        catch (TrackerException trackerException) {
            return this.getIssueType(value, projectKey, false);
        }
    }

    public RemoteIssueType getIssueType(String value, String projectKey, boolean subtask) {
        RemoteIssueType[] list = this.getIssueTypesForProject(projectKey, subtask);
        int index = JiraClient.findEntityIndex(value, (AbstractNamedRemoteEntity[])list);
        if (index < 0) {
            throw new TrackerException("Issue type '" + value + "' is not valid");
        }
        return list[index];
    }

    private static RemoteIssueType[] mergeIssueTypes(RemoteIssueType[] array1, RemoteIssueType[] array2) {
        HashMap<String, RemoteIssueType> result = new HashMap<String, RemoteIssueType>();
        if (array1 != null) {
            for (RemoteIssueType each : array1) {
                if (result.get(each.getId()) != null) continue;
                result.put(each.getId(), each);
            }
        }
        if (array2 != null) {
            for (RemoteIssueType each : array2) {
                if (result.get(each.getId()) != null) continue;
                result.put(each.getId(), each);
            }
        }
        return result.values().toArray(new RemoteIssueType[0]);
    }

    private Long getProjectId(String projectKey) {
        try {
            return Long.valueOf(projectKey);
        }
        catch (NumberFormatException e) {
            RemoteProject project = this.getProject(projectKey);
            return Long.valueOf(project.getId());
        }
    }

    public RemoteIssueType[] getIssueTypesForProject(String project, boolean subtask) {
        try {
            Long id = this.getProjectId(project);
            RemoteIssueType[] types = this.service.getIssueTypesForProject(this.token, id.toString());
            RemoteIssueType[] subTypes = null;
            if (subtask) {
                this.service.getSubTaskIssueTypesForProject(this.token, id.toString());
            }
            return JiraClient.mergeIssueTypes(types, subTypes);
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized RemoteIssueType[] getIssueTypes() {
        try {
            if (this.issueTypes.length != 0) return this.issueTypes;
            RemoteIssueType[] remoteIssueTypeArray = this.issueTypes;
            synchronized (this.issueTypes) {
                RemoteIssueType[] types = this.service.getIssueTypes(this.token);
                RemoteIssueType[] subTypes = this.service.getSubTaskIssueTypes(this.token);
                this.issueTypes = JiraClient.mergeIssueTypes(types, subTypes);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.issueTypes;
            }
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public RemotePriority[] getPriorities() {
        try {
            return this.service.getPriorities(this.token);
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public RemotePriority getPriority(String value) {
        RemotePriority[] list = this.getPriorities();
        int index = JiraClient.findEntityIndex(value, (AbstractNamedRemoteEntity[])list);
        if (index < 0) {
            throw new TrackerException("Priority '" + value + "' is not valid");
        }
        return list[index];
    }

    public RemoteResolution getResolution(String value) {
        RemoteResolution[] resolutions = this.getResolutions();
        int index = JiraClient.findEntityIndex(value, (AbstractNamedRemoteEntity[])resolutions);
        if (index < 0) {
            throw new TrackerException("Resolution '" + value + "' is not valid");
        }
        return resolutions[index];
    }

    public RemoteResolution[] getResolutions() {
        try {
            return this.service.getResolutions(this.token);
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public RemoteStatus[] getStatuses() {
        try {
            return this.service.getStatuses(this.token);
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public static AbstractNamedRemoteEntity getRemoteEntity(String entity, AbstractNamedRemoteEntity[] list) {
        if (list == null || list.length == 0) {
            return null;
        }
        int index = JiraClient.findEntityIndex(entity, list);
        if (index >= 0) {
            return list[index];
        }
        return null;
    }

    public static int findEntityIndex(String entity, AbstractNamedRemoteEntity[] list) {
        if (entity != null && list != null) {
            String value = entity.trim();
            for (int index = 0; index < list.length; ++index) {
                if (list[index] == null || !value.equalsIgnoreCase(list[index].getName()) && !value.equals(list[index].getId())) continue;
                return index;
            }
        }
        return -1;
    }

    public static int findEntityIndex(String entity, RemoteScheme[] list) {
        if (entity != null && list != null) {
            String value = entity.trim();
            for (int index = 0; index < list.length; ++index) {
                if (list[index] == null || !value.equalsIgnoreCase(list[index].getName()) && !value.equals(list[index].getId())) continue;
                return index;
            }
        }
        return -1;
    }

    public RemoteUser getRemoteUser(String userName) {
        try {
            return this.service.getUser(this.token, userName);
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public RemoteUser getMyself() {
        return this.getRemoteUser(this.getUser());
    }

    public RemoteVersion getRemoteVersion(String project, String name, boolean required) {
        RemoteVersion result = null;
        try {
            RemoteVersion[] list = this.service.getVersions(this.token, project);
            int index = JiraClient.findEntityIndex(name, (AbstractNamedRemoteEntity[])list);
            if (index >= 0) {
                result = list[index];
            }
            if (required && result == null) {
                throw new TrackerException("Version '" + name + "' not found");
            }
            return result;
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public RemoteScheme getScheme(String name, String type, boolean required) {
        RemoteScheme result = null;
        RemoteScheme[] list = null;
        try {
            if (!"".equals(name)) {
                if ("Issue Security".equalsIgnoreCase(type)) {
                    list = this.service.getSecuritySchemes(this.token);
                } else if ("Notification".equalsIgnoreCase(type)) {
                    list = this.service.getNotificationSchemes(this.token);
                } else if ("Permission".equalsIgnoreCase(type)) {
                    list = this.service.getPermissionSchemes(this.token);
                }
            }
        }
        catch (RemotePermissionException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteAuthenticationException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        int index = JiraClient.findEntityIndex(name, list);
        if (index >= 0) {
            result = list[index];
        }
        if (required && result == null) {
            throw new TrackerException(type + "scheme '" + name + "' not found");
        }
        return result;
    }

    public String getRemoteFieldId(String field) {
        try {
            return this.getRemoteField(field).getId();
        }
        catch (RemotePermissionException e) {
            return JiraClient.getCustomFieldId(field);
        }
    }

    public String getRemoteFieldName(String field) {
        try {
            return this.getRemoteField(field).getName();
        }
        catch (RemotePermissionException e) {
            return field;
        }
    }

    private RemoteField getRemoteField(String field) throws RemotePermissionException {
        try {
            String fieldAsId;
            RemoteField[] list = this.service.getCustomFields(this.token);
            int index = JiraClient.findEntityIndex(field, (AbstractNamedRemoteEntity[])list);
            if (index < 0 && (index = JiraClient.findEntityIndex(fieldAsId = "customfield_" + field, (AbstractNamedRemoteEntity[])list)) < 0) {
                throw new TrackerException("Custom field '" + field + "' is not valid");
            }
            return list[index];
        }
        catch (RemotePermissionException e) {
            throw new RemotePermissionException();
        }
        catch (org.swift.common.soap.jira.RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    protected static enum Action {
        CREATEISSUE("create"),
        CREATEPROJECT("createproject"),
        UPDATEISSUE("update");

        String command;

        private Action(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }

        public static Action fromCommand(String command) {
            for (Action a : Action.values()) {
                if (!a.getCommand().equalsIgnoreCase(command)) continue;
                return a;
            }
            throw new IllegalArgumentException("Unsupported command: " + command);
        }

        public static String[] availableCommands() {
            ArrayList<String> commands = new ArrayList<String>();
            for (Action a : Action.values()) {
                commands.add(a.getCommand());
            }
            return commands.toArray(new String[commands.size()]);
        }
    }
}

